/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.BiomeStepConfig;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.JavascriptExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.npm.EslintConfig;
import com.diffplug.spotless.npm.EslintFormatterStep;
import com.diffplug.spotless.npm.EslintTypescriptConfig;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import com.diffplug.spotless.npm.TsConfigFileType;
import com.diffplug.spotless.npm.TsFmtFormatterStep;
import com.diffplug.spotless.npm.TypedTsFmtConfigFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Project;

public class TypescriptExtension
extends FormatExtension {
    static final String NAME = "typescript";

    @Inject
    public TypescriptExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public TypescriptFormatExtension tsfmt() {
        return this.tsfmt(TsFmtFormatterStep.defaultDevDependencies());
    }

    public TypescriptFormatExtension tsfmt(String version) {
        return this.tsfmt(TsFmtFormatterStep.defaultDevDependenciesWithTsFmt((String)version));
    }

    public TypescriptFormatExtension tsfmt(Map<String, String> devDependencies) {
        TypescriptFormatExtension tsfmt = new TypescriptFormatExtension(devDependencies);
        this.addStep(tsfmt.createStep());
        return tsfmt;
    }

    @Override
    public FormatExtension.PrettierConfig prettier() {
        return this.prettier(PrettierFormatterStep.defaultDevDependencies());
    }

    @Override
    public FormatExtension.PrettierConfig prettier(String version) {
        return this.prettier(PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)version));
    }

    @Override
    public FormatExtension.PrettierConfig prettier(Map<String, String> devDependencies) {
        TypescriptPrettierConfig prettierConfig = new TypescriptPrettierConfig(devDependencies);
        this.addStep(((FormatExtension.PrettierConfig)prettierConfig).createStep());
        return prettierConfig;
    }

    public TypescriptEslintConfig eslint() {
        return this.eslint(EslintFormatterStep.defaultDevDependenciesForTypescript());
    }

    public TypescriptEslintConfig eslint(String version) {
        return this.eslint(EslintFormatterStep.defaultDevDependenciesTypescriptWithEslint((String)version));
    }

    public TypescriptEslintConfig eslint(Map<String, String> devDependencies) {
        TypescriptEslintConfig eslint = new TypescriptEslintConfig(devDependencies);
        this.addStep(eslint.createStep());
        return eslint;
    }

    public BiomeTs biome() {
        return this.biome(null);
    }

    public BiomeTs biome(String version) {
        BiomeTs biomeConfig = new BiomeTs(version);
        this.addStep(biomeConfig.createStep());
        return biomeConfig;
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public class TypescriptFormatExtension
    extends FormatExtension.NpmStepConfig<TypescriptFormatExtension> {
        private Map<String, Object> config;
        @Nullable
        TsConfigFileType configFileType;
        @Nullable
        Object configFilePath;
        private final Map<String, String> devDependencies;

        TypescriptFormatExtension(Map<String, String> devDependencies) {
            super(TypescriptExtension.this.getProject(), TypescriptExtension.this::replaceStep);
            this.config = Collections.emptyMap();
            this.configFileType = null;
            this.devDependencies = Objects.requireNonNull(devDependencies);
        }

        public TypescriptFormatExtension config(Map<String, Object> config) {
            this.config = new TreeMap<String, Object>(Objects.requireNonNull(config));
            this.replaceStep();
            return this;
        }

        public TypescriptFormatExtension tsconfigFile(Object path) {
            return this.configFile(TsConfigFileType.TSCONFIG, path);
        }

        public TypescriptFormatExtension tslintFile(Object path) {
            return this.configFile(TsConfigFileType.TSLINT, path);
        }

        public TypescriptFormatExtension vscodeFile(Object path) {
            return this.configFile(TsConfigFileType.VSCODE, path);
        }

        public TypescriptFormatExtension tsfmtFile(Object path) {
            return this.configFile(TsConfigFileType.TSFMT, path);
        }

        private TypescriptFormatExtension configFile(TsConfigFileType filetype, Object path) {
            this.configFileType = Objects.requireNonNull(filetype);
            this.configFilePath = Objects.requireNonNull(path);
            this.replaceStep();
            return this;
        }

        @Override
        public FormatterStep createStep() {
            Project project = TypescriptExtension.this.getProject();
            return TsFmtFormatterStep.create(this.devDependencies, (Provisioner)TypescriptExtension.this.provisioner(), (File)project.getProjectDir(), (File)((File)project.getLayout().getBuildDirectory().getAsFile().get()), (File)this.npmModulesCacheOrNull(), (NpmPathResolver)new NpmPathResolver(this.npmFileOrNull(), this.nodeFileOrNull(), this.npmrcFileOrNull(), Arrays.asList(project.getProjectDir(), project.getRootDir())), (TypedTsFmtConfigFile)this.typedConfigFile(), this.config);
        }

        private TypedTsFmtConfigFile typedConfigFile() {
            if (this.configFileType != null && this.configFilePath != null) {
                return new TypedTsFmtConfigFile(this.configFileType, TypescriptExtension.this.getProject().file(this.configFilePath));
            }
            return null;
        }
    }

    public class TypescriptPrettierConfig
    extends FormatExtension.PrettierConfig {
        TypescriptPrettierConfig(Map<String, String> devDependencies) {
            super(devDependencies);
        }

        @Override
        protected FormatterStep createStep() {
            this.fixParserToTypescript();
            return super.createStep();
        }

        private void fixParserToTypescript() {
            if (this.prettierConfig == null) {
                this.prettierConfig = new TreeMap<String, String>(Map.of("parser", TypescriptExtension.NAME));
            } else {
                String replaced = this.prettierConfig.put("parser", TypescriptExtension.NAME);
                if (replaced != null) {
                    TypescriptExtension.this.getProject().getLogger().warn("overriding parser option to 'typescript'. Was set to '{}'", (Object)replaced);
                }
            }
        }
    }

    public class TypescriptEslintConfig
    extends JavascriptExtension.EslintBaseConfig<TypescriptEslintConfig> {
        @Nullable
        Object typescriptConfigFilePath;

        public TypescriptEslintConfig(Map<String, String> devDependencies) {
            super(TypescriptExtension.this.getProject(), TypescriptExtension.this::replaceStep, devDependencies);
        }

        public TypescriptEslintConfig tsconfigFile(Object path) {
            this.typescriptConfigFilePath = Objects.requireNonNull(path);
            this.replaceStep();
            return this;
        }

        @Override
        public FormatterStep createStep() {
            Project project = TypescriptExtension.this.getProject();
            return EslintFormatterStep.create((Map)this.devDependencies, (Provisioner)TypescriptExtension.this.provisioner(), (File)project.getProjectDir(), (File)((File)project.getLayout().getBuildDirectory().getAsFile().get()), (File)this.npmModulesCacheOrNull(), (NpmPathResolver)new NpmPathResolver(this.npmFileOrNull(), this.nodeFileOrNull(), this.npmrcFileOrNull(), Arrays.asList(project.getProjectDir(), project.getRootDir())), (EslintConfig)this.eslintConfig());
        }

        protected EslintConfig eslintConfig() {
            return new EslintTypescriptConfig(this.configFilePath != null ? TypescriptExtension.this.getProject().file(this.configFilePath) : null, this.configJs, this.typescriptConfigFilePath != null ? TypescriptExtension.this.getProject().file(this.typescriptConfigFilePath) : null);
        }
    }

    public class BiomeTs
    extends BiomeStepConfig<BiomeTs> {
        public BiomeTs(String version) {
            super(TypescriptExtension.this.getProject(), TypescriptExtension.this::replaceStep, version);
        }

        @Override
        protected String getLanguage() {
            return "ts?";
        }

        @Override
        protected BiomeTs getThis() {
            return this;
        }
    }
}

