/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class DiktatStep {
    private static final String DEFAULT_VERSION = "1.1.0";
    static final String NAME = "diktat";
    static final String PACKAGE_DIKTAT = "org.cqfn.diktat";
    static final String MAVEN_COORDINATE = "org.cqfn.diktat:diktat-rules:";

    private DiktatStep() {
    }

    public static String defaultVersionDiktat() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return DiktatStep.create(DiktatStep.defaultVersionDiktat(), provisioner);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner) {
        return DiktatStep.create(versionDiktat, provisioner, Collections.emptyMap(), null);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, Collections.emptyMap(), config);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, Map<String, String> userData, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, false, userData, config);
    }

    public static FormatterStep createForScript(String versionDiktat, Provisioner provisioner, @Nullable FileSignature config) {
        return DiktatStep.createForScript(versionDiktat, provisioner, Collections.emptyMap(), config);
    }

    public static FormatterStep createForScript(String versionDiktat, Provisioner provisioner, Map<String, String> userData, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, true, userData, config);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, boolean isScript, Map<String, String> userData, @Nullable FileSignature config) {
        Objects.requireNonNull(versionDiktat, "versionDiktat");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(versionDiktat, provisioner, isScript, userData, config), State::createFormat);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        @Nullable
        private final FileSignature config;
        final JarState jar;
        private final TreeMap<String, String> userData;

        State(String versionDiktat, Provisioner provisioner, boolean isScript, Map<String, String> userData, @Nullable FileSignature config) throws IOException {
            HashSet<String> pkgSet = new HashSet<String>();
            pkgSet.add(DiktatStep.MAVEN_COORDINATE + versionDiktat);
            this.userData = new TreeMap<String, String>(userData);
            this.jar = JarState.from(pkgSet, provisioner);
            this.isScript = isScript;
            this.config = config;
        }

        FormatterFunc createFormat() throws Exception {
            if (this.config != null) {
                System.setProperty("diktat.config.path", this.config.getOnlyFile().getAbsolutePath());
            }
            Class<?> formatterFunc = this.jar.getClassLoader().loadClass("com.diffplug.spotless.glue.diktat.DiktatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(Boolean.TYPE, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.isScript, this.userData);
        }
    }
}

