/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import com.day.any.AnyInputStreamReader;
import com.day.any.DirectiveHandler;
import com.day.any.Handler;
import com.day.any.Lexer;
import com.day.any.ParseException;
import com.day.any.ResourceExpander;
import com.day.text.Text;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger((Class)(class$com$day$any$Parser == null ? (class$com$day$any$Parser = Parser.class$("com.day.any.Parser")) : class$com$day$any$Parser));
    private final Handler handler;
    private EntityResolver entityResolver;
    private ResourceExpander expander;
    private final Map directiveHandlers;
    static /* synthetic */ Class class$com$day$any$Parser;

    public Parser(Handler handler) {
        this.handler = handler;
        this.directiveHandlers = new HashMap();
        this.setDirectiveHandler(new DefaultIncludeDirectiveHandler());
    }

    public ResourceExpander getResourceExpander() {
        return this.expander;
    }

    public void setResourceExpander(ResourceExpander expander) {
        this.expander = expander;
    }

    public void setDirectiveHandler(DirectiveHandler directiveHandler) {
        this.directiveHandlers.put(directiveHandler.getDirective(), directiveHandler);
    }

    public DirectiveHandler getDirectiveHandler(String directive) {
        return (DirectiveHandler)this.directiveHandlers.get(directive);
    }

    public void setEnitiyResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws ParseException, IOException {
        if (input.getCharacterStream() == null && input.getByteStream() == null) {
            String sysid = input.getSystemId();
            if (this.entityResolver == null) {
                log.error("InputSource provides no stream and no entity resolver is set.");
                throw new FileNotFoundException(sysid);
            }
            if (this.expander == null) {
                log.warn("InputSource provides no stream and no resource expander is set.");
            }
            try {
                input = this.entityResolver.resolveEntity("", sysid);
            }
            catch (SAXException e) {
                throw new ParseException(e);
            }
            if (input == null) {
                log.warn("Entity not available '{}': (FileNotFound).", (Object)sysid);
                throw new FileNotFoundException(sysid);
            }
            if (input.getCharacterStream() == null && input.getByteStream() == null) {
                throw new IOException("resolver did not set a input stream: " + sysid);
            }
        }
        Reader in = null;
        try {
            if (input.getCharacterStream() != null) {
                in = input.getCharacterStream();
            } else if (input.getByteStream() != null) {
                String enc = input.getEncoding();
                if (enc == null) {
                    enc = "iso-8859-1";
                }
                in = new BufferedReader(new AnyInputStreamReader(input.getByteStream(), enc));
            }
            Lexer lexer = new Lexer(in, input.getSystemId());
            lexer.next();
            this.parseStructure(lexer);
            if (lexer.type != -1) {
                throw this.expect(lexer, "end of file", lexer.type);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void parseStructure(Lexer lexer) throws ParseException {
        String identifier = null;
        int ctr = 0;
        block10: while (lexer.type != -1) {
            switch (lexer.type) {
                case 3: {
                    identifier = lexer.token;
                    ++ctr;
                    lexer.next();
                    continue block10;
                }
                case 5: {
                    if (identifier != null) {
                        throw this.expect(lexer, "value", lexer.type);
                    }
                    lexer.next();
                    return;
                }
                case 4: {
                    lexer.next();
                    if (identifier == null) {
                        identifier = String.valueOf(ctr++);
                    }
                    this.handler.onChildBegin(identifier);
                    this.parseStructure(lexer);
                    this.handler.onChildEnd();
                    identifier = null;
                    continue block10;
                }
                case 0: {
                    if (identifier == null) {
                        identifier = String.valueOf(ctr++);
                    }
                    this.handler.onValue(identifier, lexer.token);
                    lexer.next();
                    identifier = null;
                    continue block10;
                }
                case 1: {
                    if (identifier == null) {
                        identifier = String.valueOf(ctr++);
                    }
                    this.handler.onValue(identifier, lexer.doubleNumber);
                    lexer.next();
                    identifier = null;
                    continue block10;
                }
                case 2: {
                    if (identifier == null) {
                        identifier = String.valueOf(ctr++);
                    }
                    this.handler.onValue(identifier, lexer.intNumber);
                    lexer.next();
                    identifier = null;
                    continue block10;
                }
                case 6: {
                    if (identifier != null) {
                        throw this.expect(lexer, "value", lexer.type);
                    }
                    identifier = lexer.token;
                    lexer.next();
                    this.parseDirective(lexer, identifier);
                    identifier = null;
                    continue block10;
                }
                case 7: {
                    if (identifier == null) {
                        identifier = String.valueOf(ctr++);
                    }
                    if (lexer.token.equals("null")) {
                        this.handler.onValue(identifier, "");
                    } else if (lexer.token.equals("undefined")) {
                        this.handler.onValue(identifier, "");
                    }
                    lexer.next();
                    identifier = null;
                    continue block10;
                }
            }
            throw this.expect(lexer, "never show up here", lexer.type);
        }
        if (identifier != null) {
            throw this.expect(lexer, "value", lexer.type);
        }
    }

    private void parseDirective(Lexer lexer, String name) throws ParseException {
        DirectiveHandler dirHandler = this.getDirectiveHandler(name);
        if (dirHandler == null) {
            throw new ParseException("unknown directive: " + name);
        }
        dirHandler.handle(this, lexer);
    }

    protected ParseException expect(Lexer lexer, String expected, int token) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(lexer.getLocation());
        buffer.append(": expected ");
        buffer.append(expected);
        buffer.append(", got ");
        buffer.append(Lexer.getTokenName(token));
        buffer.append(" instead");
        return new ParseException(buffer.toString());
    }

    protected ParseException expect(Lexer lexer, int tokenExpected, int token) {
        return this.expect(lexer, Lexer.getTokenName(tokenExpected), token);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DefaultIncludeDirectiveHandler
    implements DirectiveHandler {
        private DefaultIncludeDirectiveHandler() {
        }

        public String getDirective() {
            return "include";
        }

        public void handle(Parser parser, Lexer lexer) throws ParseException {
            if (lexer.type != 0) {
                throw parser.expect(lexer, "filename", 0);
            }
            String filename = lexer.token;
            lexer.next();
            if (parser.getResourceExpander() == null || parser.getEntityResolver() == null) {
                log.error("handle: Inclusion failed, HandleExpander and/or EntityResolver undefined");
                return;
            }
            try {
                String base = lexer.getSystemId();
                String fullpath = Text.fullPath((String)base, (String)filename);
                String[] handles = parser.getResourceExpander().expand(fullpath);
                for (int i = 0; i < handles.length; ++i) {
                    InputSource input = parser.getEntityResolver().resolveEntity("", handles[i]);
                    parser.parse(input);
                }
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }
}

