/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import com.day.any.ParseException;
import com.day.any.TokenType;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lexer
implements TokenType {
    private static final Logger log = LoggerFactory.getLogger((Class)(class$com$day$any$Lexer == null ? (class$com$day$any$Lexer = Lexer.class$("com.day.any.Lexer")) : class$com$day$any$Lexer));
    protected String token;
    protected double doubleNumber;
    protected int intNumber;
    protected int type = -2;
    private int next;
    private final Reader input;
    private final String systemId;
    private int tokenLine = 1;
    private int tokenCol;
    static /* synthetic */ Class class$com$day$any$Lexer;

    public Lexer(Reader reader, String systemid) throws ParseException {
        this.input = reader;
        this.systemId = systemid;
        this.read();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int next() throws ParseException {
        while (this.next != -1) {
            switch (this.next) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.lexNumber();
                }
                case 123: {
                    this.read();
                    this.type = 4;
                    return 4;
                }
                case 125: {
                    this.read();
                    this.type = 5;
                    return 5;
                }
                case 35: {
                    while (this.next != 10 && this.next != -1) {
                        this.read();
                    }
                    break;
                }
                case 47: {
                    return this.lexIdentifier();
                }
                case 34: {
                    return this.lexString();
                }
                case 36: {
                    return this.lexDirective();
                }
                case 60: {
                    return this.lexPseudoValue();
                }
                default: {
                    throw this.error("unrecognized character: " + (char)this.next);
                }
            }
            this.read();
        }
        this.type = -1;
        return -1;
    }

    private int lexString() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        this.read();
        while (this.next != 34) {
            switch (this.next) {
                case -1: {
                    throw this.error("Unexpected EOF in string constant.");
                }
                case 92: {
                    this.read();
                    if (this.next == -1) {
                        throw this.error("Unexpected EOF in string constant.");
                    }
                    if (this.next == 114) {
                        buffer.append('\r');
                        break;
                    }
                    if (this.next == 110) {
                        buffer.append('\n');
                        break;
                    }
                    if (this.next == 116) {
                        buffer.append('\t');
                        break;
                    }
                    buffer.append((char)this.next);
                    break;
                }
                default: {
                    buffer.append((char)this.next);
                }
            }
            this.read();
        }
        this.read();
        this.token = buffer.toString();
        this.type = 0;
        return 0;
    }

    /*
     * Loose catch block
     */
    private int lexNumber() throws ParseException {
        StringBuffer buffer;
        block7: {
            buffer = new StringBuffer();
            boolean isDouble = false;
            while (!Character.isWhitespace((char)this.next) && this.next != -1) {
                if (this.next == 46) {
                    isDouble = true;
                }
                buffer.append((char)this.next);
                this.read();
            }
            if (!isDouble) break block7;
            this.doubleNumber = Double.parseDouble(buffer.toString());
            this.type = 1;
            return 1;
            {
                catch (NumberFormatException e) {
                    throw this.error("not a valid number: " + buffer.toString());
                }
            }
        }
        try {
            this.intNumber = Integer.parseInt(buffer.toString());
            this.type = 2;
            return 2;
        }
        catch (NumberFormatException e) {
            this.doubleNumber = Double.parseDouble(buffer.toString());
            this.type = 1;
            return 1;
        }
    }

    private int lexIdentifier() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        this.read();
        while (!Character.isWhitespace((char)this.next) && this.next != -1) {
            if (!Character.isLetterOrDigit((char)this.next) && this.next != 95) {
                throw this.error("Identifier must contain only letters, digits or underscores");
            }
            buffer.append((char)this.next);
            this.read();
        }
        this.token = buffer.toString();
        this.type = 3;
        return 3;
    }

    private int lexDirective() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        this.read();
        while (!Character.isWhitespace((char)this.next) && this.next != -1) {
            buffer.append((char)this.next);
            this.read();
        }
        this.token = buffer.toString();
        this.type = 6;
        return 6;
    }

    private int lexPseudoValue() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        this.read();
        while (this.next != 62 && this.next != -1) {
            buffer.append((char)this.next);
            this.read();
        }
        if (this.next == -1) {
            throw this.error("Unexpected EOF in pseudo value constant.");
        }
        this.token = buffer.toString();
        this.read();
        this.type = 7;
        return 7;
    }

    private int read() throws ParseException {
        try {
            this.next = this.input.read();
            if (this.next == 10) {
                ++this.tokenLine;
                this.tokenCol = 0;
            } else {
                ++this.tokenCol;
            }
            return this.next;
        }
        catch (IOException e) {
            log.error("Invalid input in '{}', consider converting: {}", (Object)this.systemId, (Object)e.toString());
            throw new ParseException(e);
        }
    }

    public String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.systemId);
        buffer.append(" (line ");
        buffer.append(this.tokenLine);
        buffer.append(", col ");
        buffer.append(this.tokenCol);
        buffer.append(")");
        return buffer.toString();
    }

    protected ParseException error(String message) {
        return new ParseException(this.getLocation() + ": " + message);
    }

    public static String getTokenName(int type) {
        switch (type) {
            case 4: {
                return "opening brace";
            }
            case 5: {
                return "closing brace";
            }
            case -1: {
                return "end of file";
            }
            case 0: {
                return "literal string";
            }
            case 1: {
                return "literal double number";
            }
            case 2: {
                return "literal integer number";
            }
            case 3: {
                return "identifier";
            }
            case 6: {
                return "directive";
            }
            case 7: {
                return "pseudo value";
            }
        }
        return "unknown";
    }

    public String getToken() {
        return this.token;
    }

    public double getDoubleNumber() {
        return this.doubleNumber;
    }

    public int getIntNumber() {
        return this.intNumber;
    }

    public int getType() {
        return this.type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

