/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import com.day.any.AnyObject;
import com.day.any.AnyValue;
import com.day.any.Handler;
import com.day.any.ParseException;
import com.day.any.Parser;
import java.io.IOException;
import java.util.Stack;
import org.xml.sax.InputSource;

public class BaseHandler
implements Handler {
    private final AnyObject rootNode;
    private AnyObject currentNode;
    private Stack parentNodes = new Stack();

    public BaseHandler() {
        this.currentNode = this.rootNode = new AnyObject();
    }

    public AnyObject getRoot() {
        return this.rootNode;
    }

    public void onChildBegin(String name) {
        AnyObject child = new AnyObject(name);
        this.currentNode.add(child);
        this.parentNodes.push(this.currentNode);
        this.currentNode = child;
    }

    public void onChildEnd() {
        this.currentNode = (AnyObject)this.parentNodes.pop();
    }

    public void onValue(String label, String value) {
        AnyValue val = new AnyValue(label, value);
        this.currentNode.add(val);
    }

    public void onValue(String label, double value) {
        AnyValue val = new AnyValue(label, value);
        this.currentNode.add(val);
    }

    public void onValue(String label, int value) {
        AnyValue val = new AnyValue(label, value);
        this.currentNode.add(val);
    }

    public static AnyObject parse(InputSource input) throws ParseException, IOException {
        BaseHandler handler = new BaseHandler();
        Parser parser = new Parser(handler);
        parser.parse(input);
        return handler.getRoot();
    }
}

