/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import com.day.any.AnyNode;
import com.day.any.AnyNodeIterator;
import com.day.text.Text;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AnyObject
extends AnyNode {
    private ArrayList children = null;

    public AnyObject() {
    }

    public AnyObject(String label) {
        super(label);
    }

    public void add(AnyNode node) {
        if (this.children == null) {
            this.children = new ArrayList();
        } else {
            this.remove(node.getLabel());
        }
        this.children.add(node);
    }

    public void addAs(String path, AnyNode node) {
        int i;
        String[] labels = Text.explode((String)path, (int)46);
        AnyObject current = this;
        for (i = 0; i < labels.length - 1; ++i) {
            AnyNode sub = current.get(labels[i]);
            if (sub == null || sub.isValue()) {
                AnyObject child = new AnyObject(labels[i]);
                current.add(child);
                current = child;
                continue;
            }
            current = (AnyObject)sub;
        }
        node.setLabel(labels[i]);
        current.add(node);
    }

    public AnyNode remove(String label) {
        if (this.children == null) {
            return null;
        }
        if (label.equals("")) {
            return null;
        }
        AnyNode node = this.get(label);
        if (node != null) {
            this.children.remove(node);
        }
        return node;
    }

    public AnyNode get(String path) {
        int i;
        if (this.children == null) {
            return null;
        }
        if (path.equals("")) {
            return null;
        }
        AnyObject current = this;
        String[] labels = Text.explode((String)path, (int)46);
        for (i = 0; i < labels.length - 1; ++i) {
            AnyNode node = current.getDirect(labels[i]);
            if (node == null || !node.hasChildren()) {
                return null;
            }
            current = (AnyObject)node;
        }
        return current.getDirect(labels[i]);
    }

    public AnyNode getDirect(String label) {
        if (this.children == null) {
            return null;
        }
        if (label.equals("")) {
            return null;
        }
        Iterator iter = ((AbstractList)this.children).iterator();
        while (iter.hasNext()) {
            AnyNode node = (AnyNode)iter.next();
            if (!node.getLabel().equals(label)) continue;
            return node;
        }
        return null;
    }

    public Iterator iterator() {
        return this.nodeIterator();
    }

    public AnyNodeIterator nodeIterator() {
        return new iter_impl();
    }

    public void write(Writer out) throws IOException {
        this.writeChildren(out, 0);
    }

    protected void write(Writer out, int indent) throws IOException {
        String label = this.getLabel();
        if (!label.equals("")) {
            out.write(AnyNode.SPACES, 0, indent);
            out.write(47);
            out.write(label.toCharArray());
            out.write(10);
        }
        out.write(AnyNode.SPACES, 0, indent += 2);
        out.write(123);
        out.write(10);
        this.writeChildren(out, indent);
        out.write(AnyNode.SPACES, 0, indent);
        out.write(125);
        out.write(10);
    }

    private void writeChildren(Writer out, int indent) throws IOException {
        if (this.children != null) {
            Iterator iter = ((AbstractList)this.children).iterator();
            while (iter.hasNext()) {
                ((AnyNode)iter.next()).write(out, indent);
            }
        }
    }

    public void write(OutputStream out, String enc) throws IOException, UnsupportedEncodingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        writer.write("#encoding:" + enc + "\n");
        this.writeChildren(writer, 0);
        ((Writer)writer).flush();
    }

    public void write(OutputStream out) throws IOException {
        try {
            this.write(out, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("iso-8859-1 is not a valid encoding???");
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public boolean isValue() {
        return false;
    }

    private class iter_impl
    implements AnyNodeIterator {
        Iterator iter;

        public iter_impl() {
            if (AnyObject.this.children != null) {
                this.iter = ((AbstractList)AnyObject.this.children).iterator();
            }
        }

        public boolean hasNext() {
            return this.iter != null && this.iter.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return this.nextNode();
        }

        public AnyNode nextNode() throws NoSuchElementException {
            if (this.iter == null) {
                throw new NoSuchElementException();
            }
            return (AnyNode)this.iter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

