/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import java.util.Objects;

public class DaoCacheKey {
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier tableId;
    private final String executionProfileName;
    private final DriverExecutionProfile executionProfile;

    public DaoCacheKey(CqlIdentifier keyspaceId, CqlIdentifier tableId, String executionProfileName, DriverExecutionProfile executionProfile) {
        this.keyspaceId = keyspaceId;
        this.tableId = tableId;
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
    }

    public DaoCacheKey(CqlIdentifier keyspaceId, String tableName, String executionProfileName, DriverExecutionProfile executionProfile) {
        this(keyspaceId, DaoCacheKey.toId(tableName), executionProfileName, executionProfile);
    }

    public DaoCacheKey(String keyspaceName, CqlIdentifier tableId, String executionProfileName, DriverExecutionProfile executionProfile) {
        this(DaoCacheKey.toId(keyspaceName), tableId, executionProfileName, executionProfile);
    }

    public DaoCacheKey(String keyspaceName, String tableName, String executionProfileName, DriverExecutionProfile executionProfile) {
        this(DaoCacheKey.toId(keyspaceName), DaoCacheKey.toId(tableName), executionProfileName, executionProfile);
    }

    private static CqlIdentifier toId(String name) {
        return name == null ? null : CqlIdentifier.fromCql((String)name);
    }

    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DaoCacheKey) {
            DaoCacheKey that = (DaoCacheKey)other;
            return Objects.equals(this.keyspaceId, that.keyspaceId) && Objects.equals(this.tableId, that.tableId) && Objects.equals(this.executionProfileName, that.executionProfileName) && Objects.equals(this.executionProfile, that.executionProfile);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspaceId, this.tableId, this.executionProfileName, this.executionProfile);
    }
}

