/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.org.jctools.queues.atomic;

import ddtrot.org.jctools.queues.MessagePassingQueue;
import ddtrot.org.jctools.queues.MessagePassingQueueUtil;
import ddtrot.org.jctools.queues.atomic.AtomicQueueUtil;
import ddtrot.org.jctools.queues.atomic.SpmcAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpmcAtomicArrayQueue<E>
extends SpmcAtomicArrayQueueL3Pad<E> {
    public SpmcAtomicArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(currProducerIndex, mask);
        if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > (long)mask) {
                return false;
            }
            while (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
            }
        }
        AtomicQueueUtil.soRefElement(buffer, offset, e);
        this.soProducerIndex(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L));
        return this.removeElement(this.buffer, currentConsumerIndex, this.mask);
    }

    private E removeElement(AtomicReferenceArray<E> buffer, long index, int mask) {
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
        E e = AtomicQueueUtil.lpRefElement(buffer, offset);
        AtomicQueueUtil.soRefElement(buffer, offset, null);
        return e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        long nextConsumerIndex = this.lvConsumerIndex();
        do {
            if ((currentConsumerIndex = nextConsumerIndex) >= currProducerIndexCache) {
                long currProducerIndex = this.lvProducerIndex();
                if (currentConsumerIndex >= currProducerIndex) {
                    return null;
                }
                currProducerIndexCache = currProducerIndex;
                this.svProducerIndexCache(currProducerIndex);
            }
            e = AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(currentConsumerIndex, mask));
            nextConsumerIndex = this.lvConsumerIndex();
        } while (null == e || nextConsumerIndex != currentConsumerIndex);
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
        if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
            return false;
        }
        AtomicQueueUtil.soRefElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        Object e;
        long currentConsumerIndex;
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long nextConsumerIndex = this.lvConsumerIndex();
        do {
            currentConsumerIndex = nextConsumerIndex;
            e = AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(currentConsumerIndex, mask));
        } while ((nextConsumerIndex = this.lvConsumerIndex()) != currentConsumerIndex);
        return e;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        int remaining;
        long currentConsumerIndex;
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        int adjustedLimit = 0;
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return 0;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + (long)(adjustedLimit = Math.min(remaining = (int)(currProducerIndexCache - currentConsumerIndex), limit))));
        for (int i = 0; i < adjustedLimit; ++i) {
            c.accept(this.removeElement(buffer, currentConsumerIndex + (long)i, mask));
        }
        return adjustedLimit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        for (int i = 0; i < limit; ++i) {
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
            if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
                return i;
            }
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
        return limit;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return MessagePassingQueueUtil.drain(this, c);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, w, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        MessagePassingQueueUtil.fill(this, s, w, e);
    }
}

