/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.jnr.posix;

import ddtrot.jnr.constants.Constant;
import ddtrot.jnr.ffi.Platform;
import ddtrot.jnr.ffi.mapper.FromNativeContext;
import ddtrot.jnr.ffi.mapper.FromNativeConverter;
import ddtrot.jnr.ffi.mapper.ToNativeContext;
import ddtrot.jnr.ffi.mapper.ToNativeConverter;
import ddtrot.jnr.ffi.mapper.TypeMapper;
import ddtrot.jnr.posix.AixPOSIX;
import ddtrot.jnr.posix.BaseNativePOSIX;
import ddtrot.jnr.posix.DragonFlyPOSIX;
import ddtrot.jnr.posix.FileStat;
import ddtrot.jnr.posix.FreeBSDPOSIX;
import ddtrot.jnr.posix.Group;
import ddtrot.jnr.posix.HANDLE;
import ddtrot.jnr.posix.LinuxPOSIX;
import ddtrot.jnr.posix.MacOSPOSIX;
import ddtrot.jnr.posix.MsgHdr;
import ddtrot.jnr.posix.NativeTimes;
import ddtrot.jnr.posix.OpenBSDPOSIX;
import ddtrot.jnr.posix.Passwd;
import ddtrot.jnr.posix.SolarisPOSIX;
import ddtrot.jnr.posix.WString;
import ddtrot.jnr.posix.WindowsPOSIX;
import ddtrot.jnr.posix.util.Platform;

final class POSIXTypeMapper
implements TypeMapper {
    public static final TypeMapper INSTANCE = new POSIXTypeMapper();

    private POSIXTypeMapper() {
    }

    @Override
    public FromNativeConverter getFromNativeConverter(Class klazz) {
        if (Passwd.class.isAssignableFrom(klazz)) {
            if (Platform.IS_MAC) {
                return MacOSPOSIX.PASSWD;
            }
            if (Platform.IS_LINUX) {
                return LinuxPOSIX.PASSWD;
            }
            if (Platform.IS_SOLARIS) {
                return SolarisPOSIX.PASSWD;
            }
            if (Platform.IS_FREEBSD) {
                return FreeBSDPOSIX.PASSWD;
            }
            if (Platform.IS_DRAGONFLY) {
                return DragonFlyPOSIX.PASSWD;
            }
            if (Platform.IS_OPENBSD) {
                return OpenBSDPOSIX.PASSWD;
            }
            if (Platform.IS_WINDOWS) {
                return WindowsPOSIX.PASSWD;
            }
            if (ddtrot.jnr.ffi.Platform.getNativePlatform().getOS().equals((Object)Platform.OS.AIX)) {
                return AixPOSIX.PASSWD;
            }
            return null;
        }
        if (Group.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.GROUP;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        return null;
    }

    @Override
    public ToNativeConverter getToNativeConverter(Class klazz) {
        if (FileStat.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.FileStatConverter;
        }
        if (NativeTimes.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.TimesConverter;
        }
        if (Constant.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.ConstantConverter;
        }
        if (WString.class.isAssignableFrom(klazz)) {
            return WString.Converter;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        if (MsgHdr.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.MsgHdrConverter;
        }
        return null;
    }

    public final ToNativeConverter getToNativeConverter(Class klazz, ToNativeContext context) {
        return this.getToNativeConverter(klazz);
    }

    public final FromNativeConverter getFromNativeConverter(Class klazz, FromNativeContext context) {
        return this.getFromNativeConverter(klazz);
    }
}

