/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import datadog.trace.api.interceptor.AbstractTraceInterceptor;
import datadog.trace.api.interceptor.MutableSpan;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.util.TraceUtils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeTraceInterceptor
extends AbstractTraceInterceptor {
    public static final DDIntakeTraceInterceptor INSTANCE = new DDIntakeTraceInterceptor(AbstractTraceInterceptor.Priority.DD_INTAKE);
    private static final Logger log = LoggerFactory.getLogger(DDIntakeTraceInterceptor.class);

    protected DDIntakeTraceInterceptor(AbstractTraceInterceptor.Priority priority) {
        super(priority);
    }

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        if (trace.isEmpty()) {
            return trace;
        }
        for (MutableSpan mutableSpan : trace) {
            if (!(mutableSpan instanceof DDSpan)) continue;
            this.process((DDSpan)mutableSpan);
        }
        return trace;
    }

    private void process(DDSpan span) {
        span.setServiceName(TraceUtils.normalizeServiceName(span.getServiceName()));
        span.setOperationName(TraceUtils.normalizeOperationName(span.getOperationName()));
        span.setSpanType(TraceUtils.normalizeSpanType(span.getType()));
        if (span.getResourceName() == null || span.getResourceName().length() == 0) {
            log.debug("Fixing malformed trace. Resource is empty (reason:resource_empty), setting span.resource={}: {}", (Object)span.getOperationName(), (Object)span);
            span.setResourceName(span.getOperationName());
        }
        span.setTag("env", TraceUtils.normalizeEnv((String)span.getTag("env")));
        short httpStatusCode = span.getHttpStatusCode();
        if (httpStatusCode != 0 && !TraceUtils.isValidStatusCode(httpStatusCode)) {
            log.debug("Fixing malformed trace. HTTP status code is invalid (reason:invalid_http_status_code), dropping invalid http.status_code={}: {}", (Object)httpStatusCode, (Object)span);
            span.setHttpStatusCode(0);
        }
    }
}

