/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class Payload {
    private static final ByteBuffer EMPTY_ARRAY = ByteBuffer.allocate(1).put(0, (byte)-112);
    private int traceCount = 0;
    private long droppedTraces = 0L;
    private long droppedSpans = 0L;
    protected ByteBuffer body = EMPTY_ARRAY.duplicate();

    public Payload withBody(int traceCount, ByteBuffer body) {
        this.traceCount = traceCount;
        if (null != body) {
            this.body = body;
        }
        return this;
    }

    public Payload withDroppedTraces(long droppedTraceCount) {
        this.droppedTraces += droppedTraceCount;
        return this;
    }

    public Payload withDroppedSpans(long droppedSpanCount) {
        this.droppedSpans += droppedSpanCount;
        return this;
    }

    public int traceCount() {
        return this.traceCount;
    }

    public long droppedTraces() {
        return this.droppedTraces;
    }

    public long droppedSpans() {
        return this.droppedSpans;
    }

    public abstract int sizeInBytes();

    public abstract void writeTo(WritableByteChannel var1) throws IOException;

    public abstract RequestBody toRequest();

    protected int msgpackArrayHeaderSize(int count) {
        if (count < 16) {
            return 1;
        }
        if (count < 65536) {
            return 3;
        }
        return 5;
    }

    protected int msgpackMapHeaderSize(int count) {
        if (count < 16) {
            return 1;
        }
        if (count < 65536) {
            return 3;
        }
        return 5;
    }

    protected ByteBuffer msgpackArrayHeader(int count) {
        if (count < 16) {
            return ByteBuffer.allocate(1).put(0, (byte)(0x90 | count));
        }
        if (count < 65536) {
            return ByteBuffer.allocate(3).put(0, (byte)-36).putShort(1, (short)count);
        }
        return ByteBuffer.allocate(5).put(0, (byte)-35).putInt(1, count);
    }

    protected ByteBuffer msgpackMapHeader(int count) {
        if (count < 16) {
            return ByteBuffer.allocate(1).put(0, (byte)(0x80 | count));
        }
        if (count < 65536) {
            return ByteBuffer.allocate(3).put(0, (byte)-34).putShort((short)count);
        }
        return ByteBuffer.allocate(5).put(0, (byte)-33).putInt(1, count);
    }
}

