/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class IntegrationsCollector {
    private static final IntegrationsCollector INSTANCE = new IntegrationsCollector();
    private final Queue<Integration> integrations = new LinkedBlockingQueue<Integration>();

    private IntegrationsCollector() {
    }

    public static IntegrationsCollector get() {
        return INSTANCE;
    }

    public synchronized void update(Iterable<String> names, boolean enabled) {
        Integration i = new Integration();
        i.names = names;
        i.enabled = enabled;
        this.integrations.offer(i);
    }

    public synchronized Map<String, Boolean> drain() {
        Integration i;
        if (this.integrations.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        while ((i = this.integrations.poll()) != null) {
            boolean enabled = i.enabled;
            for (String name : i.names) {
                map.put(name, enabled);
            }
        }
        return map;
    }

    private static class Integration {
        public Iterable<String> names;
        public boolean enabled;

        private Integration() {
        }
    }
}

