/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.container;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;

public class ServerlessInfo {
    private static final String AWS_FUNCTION_VARIABLE = "AWS_LAMBDA_FUNCTION_NAME";
    private static final String EXTENSION_PATH = "/opt/extensions/datadog-agent";
    private static final ServerlessInfo INSTANCE = new ServerlessInfo();
    private final String functionName = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
    private final boolean hasExtension;

    private ServerlessInfo(String extensionPath) {
        File f;
        this.hasExtension = null == extensionPath ? false : (f = new File(extensionPath)).exists() && !f.isDirectory();
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public ServerlessInfo() {
        this(EXTENSION_PATH);
    }

    public static ServerlessInfo get() {
        return INSTANCE;
    }

    public boolean isRunningInServerlessEnvironment() {
        return this.functionName != null && !this.functionName.isEmpty();
    }

    public boolean hasExtension() {
        return this.hasExtension;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

