/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SLOReportInterval;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"from_ts", "interval", "query", "timezone", "to_ts"})
public class SloReportCreateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM_TS = "from_ts";
    private Long fromTs;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private SLOReportInterval interval;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;
    public static final String JSON_PROPERTY_TO_TS = "to_ts";
    private Long toTs;
    private Map<String, Object> additionalProperties;

    public SloReportCreateRequestAttributes() {
    }

    @JsonCreator
    public SloReportCreateRequestAttributes(@JsonProperty(required=true, value="from_ts") Long fromTs, @JsonProperty(required=true, value="query") String query, @JsonProperty(required=true, value="to_ts") Long toTs) {
        this.fromTs = fromTs;
        this.query = query;
        this.toTs = toTs;
    }

    public SloReportCreateRequestAttributes fromTs(Long fromTs) {
        this.fromTs = fromTs;
        return this;
    }

    @JsonProperty(value="from_ts")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getFromTs() {
        return this.fromTs;
    }

    public void setFromTs(Long fromTs) {
        this.fromTs = fromTs;
    }

    public SloReportCreateRequestAttributes interval(SLOReportInterval interval) {
        this.interval = interval;
        this.unparsed |= !interval.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOReportInterval getInterval() {
        return this.interval;
    }

    public void setInterval(SLOReportInterval interval) {
        if (!interval.isValid()) {
            this.unparsed = true;
        }
        this.interval = interval;
    }

    public SloReportCreateRequestAttributes query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SloReportCreateRequestAttributes timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public SloReportCreateRequestAttributes toTs(Long toTs) {
        this.toTs = toTs;
        return this;
    }

    @JsonProperty(value="to_ts")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getToTs() {
        return this.toTs;
    }

    public void setToTs(Long toTs) {
        this.toTs = toTs;
    }

    @JsonAnySetter
    public SloReportCreateRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SloReportCreateRequestAttributes sloReportCreateRequestAttributes = (SloReportCreateRequestAttributes)o;
        return Objects.equals(this.fromTs, sloReportCreateRequestAttributes.fromTs) && Objects.equals(this.interval, sloReportCreateRequestAttributes.interval) && Objects.equals(this.query, sloReportCreateRequestAttributes.query) && Objects.equals(this.timezone, sloReportCreateRequestAttributes.timezone) && Objects.equals(this.toTs, sloReportCreateRequestAttributes.toTs) && Objects.equals(this.additionalProperties, sloReportCreateRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fromTs, this.interval, this.query, this.timezone, this.toTs, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SloReportCreateRequestAttributes {\n");
        sb.append("    fromTs: ").append(this.toIndentedString(this.fromTs)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    toTs: ").append(this.toIndentedString(this.toTs)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

