/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.GetWorkspaceNetworkOptionRequest;
import com.databricks.sdk.service.settings.UpdateWorkspaceNetworkOptionRequest;
import com.databricks.sdk.service.settings.WorkspaceNetworkConfigurationService;
import com.databricks.sdk.service.settings.WorkspaceNetworkOption;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceNetworkConfigurationImpl
implements WorkspaceNetworkConfigurationService {
    private final ApiClient apiClient;

    public WorkspaceNetworkConfigurationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WorkspaceNetworkOption getWorkspaceNetworkOptionRpc(GetWorkspaceNetworkOptionRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/network", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspaceNetworkOption.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceNetworkOption updateWorkspaceNetworkOptionRpc(UpdateWorkspaceNetworkOptionRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/network", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request.getWorkspaceNetworkOption()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WorkspaceNetworkOption.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

