/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationImpl;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationsOutput;
import com.databricks.sdk.service.oauth2.ListCustomAppIntegrationsRequest;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegration;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CustomAppIntegrationAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAppIntegrationAPI.class);
    private final CustomAppIntegrationService impl;

    public CustomAppIntegrationAPI(ApiClient apiClient) {
        this.impl = new CustomAppIntegrationImpl(apiClient);
    }

    public CustomAppIntegrationAPI(CustomAppIntegrationService mock) {
        this.impl = mock;
    }

    public CreateCustomAppIntegrationOutput create(CreateCustomAppIntegration request) {
        return this.impl.create(request);
    }

    public void delete(String integrationId) {
        this.delete(new DeleteCustomAppIntegrationRequest().setIntegrationId(integrationId));
    }

    public void delete(DeleteCustomAppIntegrationRequest request) {
        this.impl.delete(request);
    }

    public GetCustomAppIntegrationOutput get(String integrationId) {
        return this.get(new GetCustomAppIntegrationRequest().setIntegrationId(integrationId));
    }

    public GetCustomAppIntegrationOutput get(GetCustomAppIntegrationRequest request) {
        return this.impl.get(request);
    }

    public Iterable<GetCustomAppIntegrationOutput> list(ListCustomAppIntegrationsRequest request) {
        return new Paginator(request, this.impl::list, GetCustomAppIntegrationsOutput::getApps, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void update(UpdateCustomAppIntegration request) {
        this.impl.update(request);
    }

    public CustomAppIntegrationService impl() {
        return this.impl;
    }
}

