/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.vectorsearch;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.vectorsearch.CreateEndpoint;
import com.databricks.sdk.service.vectorsearch.DeleteEndpointRequest;
import com.databricks.sdk.service.vectorsearch.DeleteEndpointResponse;
import com.databricks.sdk.service.vectorsearch.EndpointInfo;
import com.databricks.sdk.service.vectorsearch.GetEndpointRequest;
import com.databricks.sdk.service.vectorsearch.ListEndpointResponse;
import com.databricks.sdk.service.vectorsearch.ListEndpointsRequest;
import com.databricks.sdk.service.vectorsearch.VectorSearchEndpointsService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class VectorSearchEndpointsImpl
implements VectorSearchEndpointsService {
    private final ApiClient apiClient;

    public VectorSearchEndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public EndpointInfo createEndpoint(CreateEndpoint request) {
        String path = "/api/2.0/vector-search/endpoints";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, EndpointInfo.class, headers);
    }

    @Override
    public void deleteEndpoint(DeleteEndpointRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s", request.getEndpointName());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteEndpointResponse.class, headers);
    }

    @Override
    public EndpointInfo getEndpoint(GetEndpointRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s", request.getEndpointName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, EndpointInfo.class, headers);
    }

    @Override
    public ListEndpointResponse listEndpoints(ListEndpointsRequest request) {
        String path = "/api/2.0/vector-search/endpoints";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListEndpointResponse.class, headers);
    }
}

