/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.Delete;
import com.databricks.sdk.service.workspace.DeleteResponse;
import com.databricks.sdk.service.workspace.ExportRequest;
import com.databricks.sdk.service.workspace.ExportResponse;
import com.databricks.sdk.service.workspace.GetStatusRequest;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionsRequest;
import com.databricks.sdk.service.workspace.Import;
import com.databricks.sdk.service.workspace.ImportResponse;
import com.databricks.sdk.service.workspace.ListResponse;
import com.databricks.sdk.service.workspace.ListWorkspaceRequest;
import com.databricks.sdk.service.workspace.Mkdirs;
import com.databricks.sdk.service.workspace.MkdirsResponse;
import com.databricks.sdk.service.workspace.ObjectInfo;
import com.databricks.sdk.service.workspace.WorkspaceObjectPermissions;
import com.databricks.sdk.service.workspace.WorkspaceObjectPermissionsRequest;
import com.databricks.sdk.service.workspace.WorkspaceService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class WorkspaceImpl
implements WorkspaceService {
    private final ApiClient apiClient;

    public WorkspaceImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(Delete request) {
        String path = "/api/2.0/workspace/delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, DeleteResponse.class, headers);
    }

    @Override
    public ExportResponse export(ExportRequest request) {
        String path = "/api/2.0/workspace/export";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ExportResponse.class, headers);
    }

    @Override
    public GetWorkspaceObjectPermissionLevelsResponse getPermissionLevels(GetWorkspaceObjectPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s/permissionLevels", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetWorkspaceObjectPermissionLevelsResponse.class, headers);
    }

    @Override
    public WorkspaceObjectPermissions getPermissions(GetWorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, WorkspaceObjectPermissions.class, headers);
    }

    @Override
    public ObjectInfo getStatus(GetStatusRequest request) {
        String path = "/api/2.0/workspace/get-status";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ObjectInfo.class, headers);
    }

    @Override
    public void importContent(Import request) {
        String path = "/api/2.0/workspace/import";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, ImportResponse.class, headers);
    }

    @Override
    public ListResponse list(ListWorkspaceRequest request) {
        String path = "/api/2.0/workspace/list";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListResponse.class, headers);
    }

    @Override
    public void mkdirs(Mkdirs request) {
        String path = "/api/2.0/workspace/mkdirs";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, MkdirsResponse.class, headers);
    }

    @Override
    public WorkspaceObjectPermissions setPermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, WorkspaceObjectPermissions.class, headers);
    }

    @Override
    public WorkspaceObjectPermissions updatePermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, WorkspaceObjectPermissions.class, headers);
    }
}

