/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.CreateRepo;
import com.databricks.sdk.service.workspace.DeleteRepoRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetRepoPermissionsRequest;
import com.databricks.sdk.service.workspace.GetRepoRequest;
import com.databricks.sdk.service.workspace.ListReposRequest;
import com.databricks.sdk.service.workspace.ListReposResponse;
import com.databricks.sdk.service.workspace.RepoInfo;
import com.databricks.sdk.service.workspace.RepoPermissions;
import com.databricks.sdk.service.workspace.RepoPermissionsRequest;
import com.databricks.sdk.service.workspace.ReposImpl;
import com.databricks.sdk.service.workspace.ReposService;
import com.databricks.sdk.service.workspace.UpdateRepo;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ReposAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ReposAPI.class);
    private final ReposService impl;

    public ReposAPI(ApiClient apiClient) {
        this.impl = new ReposImpl(apiClient);
    }

    public ReposAPI(ReposService mock) {
        this.impl = mock;
    }

    public RepoInfo create(String url, String provider) {
        return this.create(new CreateRepo().setUrl(url).setProvider(provider));
    }

    public RepoInfo create(CreateRepo request) {
        return this.impl.create(request);
    }

    public void delete(long repoId) {
        this.delete(new DeleteRepoRequest().setRepoId(repoId));
    }

    public void delete(DeleteRepoRequest request) {
        this.impl.delete(request);
    }

    public RepoInfo get(long repoId) {
        return this.get(new GetRepoRequest().setRepoId(repoId));
    }

    public RepoInfo get(GetRepoRequest request) {
        return this.impl.get(request);
    }

    public GetRepoPermissionLevelsResponse getPermissionLevels(String repoId) {
        return this.getPermissionLevels(new GetRepoPermissionLevelsRequest().setRepoId(repoId));
    }

    public GetRepoPermissionLevelsResponse getPermissionLevels(GetRepoPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public RepoPermissions getPermissions(String repoId) {
        return this.getPermissions(new GetRepoPermissionsRequest().setRepoId(repoId));
    }

    public RepoPermissions getPermissions(GetRepoPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<RepoInfo> list(ListReposRequest request) {
        return new Paginator(request, this.impl::list, ListReposResponse::getRepos, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setNextPageToken(token);
        });
    }

    public RepoPermissions setPermissions(String repoId) {
        return this.setPermissions(new RepoPermissionsRequest().setRepoId(repoId));
    }

    public RepoPermissions setPermissions(RepoPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public void update(long repoId) {
        this.update(new UpdateRepo().setRepoId(repoId));
    }

    public void update(UpdateRepo request) {
        this.impl.update(request);
    }

    public RepoPermissions updatePermissions(String repoId) {
        return this.updatePermissions(new RepoPermissionsRequest().setRepoId(repoId));
    }

    public RepoPermissions updatePermissions(RepoPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public ReposService impl() {
        return this.impl;
    }
}

