/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.provisioning.CreateCustomerManagedKeyRequest;
import com.databricks.sdk.service.provisioning.CustomerManagedKey;
import com.databricks.sdk.service.provisioning.DeleteEncryptionKeyRequest;
import com.databricks.sdk.service.provisioning.EncryptionKeysImpl;
import com.databricks.sdk.service.provisioning.EncryptionKeysService;
import com.databricks.sdk.service.provisioning.GetEncryptionKeyRequest;
import com.databricks.sdk.service.provisioning.KeyUseCase;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class EncryptionKeysAPI {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionKeysAPI.class);
    private final EncryptionKeysService impl;

    public EncryptionKeysAPI(ApiClient apiClient) {
        this.impl = new EncryptionKeysImpl(apiClient);
    }

    public EncryptionKeysAPI(EncryptionKeysService mock) {
        this.impl = mock;
    }

    public CustomerManagedKey create(Collection<KeyUseCase> useCases) {
        return this.create(new CreateCustomerManagedKeyRequest().setUseCases(useCases));
    }

    public CustomerManagedKey create(CreateCustomerManagedKeyRequest request) {
        return this.impl.create(request);
    }

    public void delete(String customerManagedKeyId) {
        this.delete(new DeleteEncryptionKeyRequest().setCustomerManagedKeyId(customerManagedKeyId));
    }

    public void delete(DeleteEncryptionKeyRequest request) {
        this.impl.delete(request);
    }

    public CustomerManagedKey get(String customerManagedKeyId) {
        return this.get(new GetEncryptionKeyRequest().setCustomerManagedKeyId(customerManagedKeyId));
    }

    public CustomerManagedKey get(GetEncryptionKeyRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CustomerManagedKey> list() {
        return this.impl.list();
    }

    public EncryptionKeysService impl() {
        return this.impl;
    }
}

