/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateFunctionRequest;
import com.databricks.sdk.service.catalog.DeleteFunctionRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.FunctionInfo;
import com.databricks.sdk.service.catalog.FunctionsService;
import com.databricks.sdk.service.catalog.GetFunctionRequest;
import com.databricks.sdk.service.catalog.ListFunctionsRequest;
import com.databricks.sdk.service.catalog.ListFunctionsResponse;
import com.databricks.sdk.service.catalog.UpdateFunction;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class FunctionsImpl
implements FunctionsService {
    private final ApiClient apiClient;

    public FunctionsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public FunctionInfo create(CreateFunctionRequest request) {
        String path = "/api/2.1/unity-catalog/functions";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, FunctionInfo.class, headers);
    }

    @Override
    public void delete(DeleteFunctionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public FunctionInfo get(GetFunctionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, FunctionInfo.class, headers);
    }

    @Override
    public ListFunctionsResponse list(ListFunctionsRequest request) {
        String path = "/api/2.1/unity-catalog/functions";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListFunctionsResponse.class, headers);
    }

    @Override
    public FunctionInfo update(UpdateFunction request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, FunctionInfo.class, headers);
    }
}

