/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.streams.parameters;

import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterMetadata;
import com.databricks.client.dsi.exceptions.InputOutputException;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.utilities.ReferenceEqualityWrapper;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractParameterStream {
    protected static final int MAX_FETCH_SIZE = 4000;
    protected static final int UNKNOWN_SIZE = -1;
    protected ParameterMetadata m_parameterMetadata = null;
    protected long m_numRead = 0L;
    protected long m_lastChunkReadSize = 0L;
    protected long m_streamLength = 0L;
    protected InputStream m_stream = null;
    protected ReferenceEqualityWrapper m_streamWrapper = null;
    @Deprecated
    protected int m_type;
    protected boolean m_valuesPushed = false;

    protected AbstractParameterStream(InputStream inputStream, long l) {
        this.m_stream = inputStream;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_stream);
        this.m_streamLength = l;
    }

    @Deprecated
    protected AbstractParameterStream(InputStream inputStream, long l, ParameterMetadata parameterMetadata, int n) {
        this.m_stream = inputStream;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_stream);
        this.m_streamLength = l;
        this.m_parameterMetadata = parameterMetadata;
        this.m_type = n;
    }

    public void close() {
        if (null != this.m_stream) {
            try {
                this.m_stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stream = null;
        }
        this.m_parameterMetadata = null;
    }

    public ParameterMetadata getMetadata() {
        return this.m_parameterMetadata;
    }

    public abstract ParameterInputValue getNextValue() throws IOException;

    public boolean hasMoreData() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (-1L != this.m_streamLength) {
            return this.m_numRead < this.m_streamLength;
        }
        return this.m_lastChunkReadSize != -1L;
    }

    public ReferenceEqualityWrapper getEqualityStreamWrapper() {
        return this.m_streamWrapper;
    }

    public void setParameterMetadata(ParameterMetadata parameterMetadata) throws InputOutputException {
        if (this.m_valuesPushed) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_METADATA_SET_ERROR.name());
        }
        this.m_parameterMetadata = parameterMetadata;
        this.m_type = this.m_parameterMetadata.getTypeMetadata().getType();
    }

    protected int getNumToFetch() {
        if (-1L != this.m_streamLength) {
            long l = this.m_streamLength - this.m_numRead;
            return (int)Math.min(4000L, l);
        }
        return 4000;
    }

    protected boolean isClosed() {
        return null == this.m_stream;
    }
}

