/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class ETWeekFn
extends ETScalarFn {
    public ETWeekFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (91 == list2.get(0).getTypeMetadata().getType());
        assert (4 == iColumn.getTypeMetadata().getType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            Date date = iSqlDataWrapper.getDate();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.clear();
            gregorianCalendar.setTimeInMillis(date.getTime());
            int n = gregorianCalendar.get(6);
            n += 7 - gregorianCalendar.get(7);
            gregorianCalendar.set(2, 0);
            gregorianCalendar.set(5, 1);
            if (1 != gregorianCalendar.get(7)) {
                n += 7;
            }
            eTDataRequest.getData().setInteger(n / 7);
        }
        return false;
    }
}

