/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.datawrapper;

import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlBigIntDataWrapper
extends DefaultSqlDataWrapper {
    private BigInteger m_data = null;
    private boolean m_isSet = false;

    @Override
    public BigInteger getBigInt() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return -5;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_data = bl ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void setBigInt(BigInteger bigInteger) {
        this.m_isSet = true;
        this.m_data = bigInteger;
    }

    @Override
    public void setInteger(long l) {
        this.setData(l);
    }

    @Override
    public void setSmallInt(int n) {
        this.setData(n);
    }

    @Override
    public void setTinyInt(short s) {
        this.setData(s);
    }

    @Override
    public void setNull() {
        this.m_data = null;
        this.m_isSet = true;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -5: {
                        this.setBigInt(dataWrapper.getBigInt());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 4: {
                        this.setInteger(dataWrapper.getInteger());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setBigInt(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }

    private void setData(long l) {
        this.m_isSet = true;
        this.m_data = BigInteger.valueOf(l);
    }
}

