/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor;

import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContext;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterOutputValue;
import com.databricks.client.dsi.dataengine.utilities.ParameterType;
import com.databricks.client.dsi.exceptions.DefaultParamException;
import com.databricks.client.dsi.exceptions.ParamAlreadyPushedException;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.databricks.client.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.ETProcedureResultSet;
import com.databricks.client.sqlengine.executor.IStatementExecutor;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.etree.ETResourceManager;
import com.databricks.client.sqlengine.executor.etree.statement.ETProcedureCall;
import com.databricks.client.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.databricks.client.sqlengine.executor.etree.value.ETParameter;
import com.databricks.client.sqlengine.executor.materializer.MaterializerContext;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcedureExecutor
implements IStatementExecutor {
    private ETProcedureCall m_etProcedureCall;
    private AEProcedureCall m_aeProcedureCall;
    private ETResourceManager m_rscManager;
    private final ETCancelState m_cancelState;
    private Object m_cancelLock;
    private boolean m_isCanceled;
    private MaterializerContext m_materializerContext;

    public ProcedureExecutor(ETProcedureCall eTProcedureCall, AEProcedureCall aEProcedureCall, MaterializerContext materializerContext) {
        if (null == eTProcedureCall.getProcedure()) {
            throw new IllegalArgumentException();
        }
        this.m_etProcedureCall = eTProcedureCall;
        this.m_aeProcedureCall = aEProcedureCall;
        this.m_rscManager = materializerContext.getResourceManager();
        this.m_cancelState = materializerContext.getCancelState();
        this.m_isCanceled = false;
        this.m_cancelLock = new Object();
        this.m_materializerContext = materializerContext;
    }

    @Override
    public void close() {
        if (this.m_etProcedureCall.isResultSet()) {
            try {
                this.m_etProcedureCall.getOperand().close(true);
            }
            catch (Exception exception) {
                LogUtilities.logError(exception, this.m_materializerContext.getLog());
            }
            this.m_etProcedureCall = null;
            if (null != this.m_rscManager) {
                try {
                    this.m_rscManager.free();
                }
                catch (Exception exception) {
                    LogUtilities.logError(exception, this.m_materializerContext.getLog());
                }
                this.m_rscManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelExecution() {
        Object object = this.m_cancelLock;
        synchronized (object) {
            this.m_isCanceled = true;
            this.m_cancelState.cancel();
        }
    }

    @Override
    public ETCancelState getCancelState() {
        return this.m_cancelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(ExecutionContext executionContext) throws ErrorException {
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_isCanceled) {
                throw SQLEngineExceptionFactory.operationCanceledException();
            }
            this.m_cancelState.clearCancel();
        }
        if (this.m_etProcedureCall.getOperand().isOpen()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple active open result sets is not supported.");
        }
        this.pushParameters(executionContext);
        object = new ETProcedureResultSet(this.m_etProcedureCall, this.m_rscManager, this.m_cancelState);
        ((ETProcedureResultSet)object).open(CursorType.FORWARD_ONLY);
        return ((ETProcedureResultSet)object).getExecutionResult();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etProcedureCall);
    }

    private void pushParameters(ExecutionContext executionContext) {
        List<ProcedureParameterMetadata> list = this.m_aeProcedureCall.getOperand().getExpectedDynamicParamMeta();
        ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
        ArrayList<ParameterOutputValue> arrayList2 = executionContext.getOutputs();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<Integer, ETParameter> entry : this.m_etProcedureCall.getParameters().entrySet()) {
            int n3 = entry.getKey();
            try {
                Object object;
                ParameterType parameterType = entry.getValue().getParamType();
                if (ParameterType.OUTPUT == parameterType || ParameterType.RETURN_VALUE == parameterType) {
                    object = arrayList2.get(n2);
                    entry.getValue().setOutputData(((ParameterOutputValue)object).getData());
                    entry.getValue().setCachedDataWrapper(((ParameterOutputValue)object).getData());
                    ++n2;
                    continue;
                }
                if (ParameterType.INPUT == parameterType || ParameterType.INPUT_OUTPUT == parameterType) {
                    object = arrayList.get(n);
                    entry.getValue().setInputData(((ParameterInputValue)object).getData());
                    ++n;
                    if (ParameterType.INPUT_OUTPUT != parameterType) continue;
                    ParameterOutputValue parameterOutputValue = arrayList2.get(n2);
                    entry.getValue().setCachedDataWrapper(parameterOutputValue.getData());
                    ++n2;
                    continue;
                }
                throw new IllegalStateException("Invalid parameter type.");
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new IllegalStateException("pushed parameter encountered during execution.");
            }
            catch (DefaultParamException defaultParamException) {
                throw new IllegalStateException("Default parameter encountered during execution.");
            }
        }
    }

    @Override
    public void startBatch() {
    }

    @Override
    public void endBatch() throws ErrorException {
    }

    @Override
    public boolean generatesResultSet() {
        return true;
    }
}

