/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder.value;

import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEScalarFnMetadataFactory;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.databricks.client.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECastFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.databricks.client.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTLiteralNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTListType;
import com.databricks.client.sqlengine.parser.type.PTLiteralType;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class AEScalarFnBuilder
extends AEBuilderBase<AEValueExpr> {
    private static final Map<String, Map<Integer, ScalarFunctionID>> SCALAR_FN_LOOKUP;
    private SqlDataEngine m_dataEngine;

    protected AEScalarFnBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEValueExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        ScalarFunctionID scalarFunctionID;
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.FUNC)).withExactChildren(PTPositionalType.NAME, AEBuilderCheck.identifier(), PTPositionalType.PARAM_LIST, AEBuilderCheck.optionalList(PTListType.PARAMETER_LIST)));
        String string = ((PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.NAME)).getIdentifier();
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode = iPTNode.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)iPTNode;
        CustomScalarFunction customScalarFunction = this.m_dataEngine.openScalarFunction(string, pTListNode.numChildren());
        if (null != customScalarFunction) {
            return this.buildCustomScalarFn(pTListNode, customScalarFunction);
        }
        Map<Integer, ScalarFunctionID> map = SCALAR_FN_LOOKUP.get(string);
        if (null == map) {
            throw SQLEngineExceptionFactory.invalidScalarFnNameException(string);
        }
        int n = pTListNode.numChildren();
        if (this.IsCastFunctionWithFormatClause(string, pTListNode)) {
            --n;
        }
        if (null == (scalarFunctionID = map.get(n))) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
        }
        return this.buildScalarFn(string, scalarFunctionID, pTListNode);
    }

    private AECustomScalarFn buildCustomScalarFn(PTListNode pTListNode, CustomScalarFunction customScalarFunction) throws ErrorException {
        AEValueExprList aEValueExprList = new AEValueExprList();
        if (0 < pTListNode.numChildren()) {
            AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
            for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                aEValueExprList.addNode(aEValueExprBuilder.build(iPTNode));
            }
        }
        return new AECustomScalarFn(customScalarFunction, aEValueExprList);
    }

    /*
     * WARNING - void declaration
     */
    private AEScalarFn buildScalarFn(String string, ScalarFunctionID scalarFunctionID, PTListNode pTListNode) throws ErrorException {
        void var9_15;
        Object object2;
        Object object3;
        AEValueExprList aEValueExprList = new AEValueExprList();
        ArrayList<AECoercionColumnInfo> arrayList = new ArrayList<AECoercionColumnInfo>();
        String string2 = null;
        switch (scalarFunctionID) {
            case CAST2: 
            case CAST3: 
            case CAST4: 
            case CONVERT2: 
            case CONVERT3: 
            case CONVERT4: {
                IPTNode iPTNode;
                if (pTListNode.numChildren() > 4) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                object3 = new AEValueExprBuilder(this.getQueryScope());
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(0));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                IPTNode object4 = pTListNode.getChild(1);
                if (object4 instanceof PTLiteralNode) {
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(object4);
                } else if (object4 instanceof PTIdentifierNode) {
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)object4).getIdentifier()));
                } else if (object4 instanceof PTNonterminalNode && PTNonterminalType.COLUMN_REFERENCE == ((PTNonterminalNode)object4).getNonterminalType()) {
                    iPTNode = (PTNonterminalNode)object4;
                    object2 = (AEValueExpr)((AEBuilderBase)object3).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)iPTNode.getChild(PTPositionalType.COLUMN_NAME)).getIdentifier()));
                } else {
                    throw ScalarFunctionID.CONVERT2 == scalarFunctionID || ScalarFunctionID.CONVERT3 == scalarFunctionID || ScalarFunctionID.CONVERT4 == scalarFunctionID ? SQLEngineExceptionFactory.invalidSecondArgumentToConvertException() : SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
                }
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                if (this.IsCastFunctionWithFormatClause(string, pTListNode)) {
                    iPTNode = pTListNode.getChild(pTListNode.numChildren() - 1);
                    string2 = ((PTLiteralNode)iPTNode).getStringValue();
                    pTListNode.removeChild(pTListNode.numChildren() - 1);
                }
                if (pTListNode.numChildren() < 3) break;
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(2));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                short s = Short.parseShort(((AECoercionColumnInfo)arrayList.get(2)).getLiteralString());
                if (s < 0) {
                    SQLEngineExceptionFactory.invalidScalarFunctionDataException(string, 3);
                }
                if (pTListNode.numChildren() != 4) break;
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(3));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                short s2 = Short.parseShort(((AECoercionColumnInfo)arrayList.get(3)).getLiteralString());
                if (s2 >= 0) break;
                SQLEngineExceptionFactory.invalidScalarFunctionDataException(string, 4);
                break;
            }
            case USER: 
            case DATABASE: {
                assert (0 == pTListNode.numChildren());
                object3 = this.getQueryScope().getDataEngine().getContext();
                object2 = ScalarFunctionID.USER == scalarFunctionID ? ((SqlDataEngineContext)object3).getConnProperty(139).getString() : ((SqlDataEngineContext)object3).getConnProperty(22).getString();
                AELiteral aELiteral = new AELiteral((String)object2, PTLiteralType.CHARSTR, false, (SqlDataEngineContext)object3);
                aELiteral.setParent(aEValueExprList);
                aEValueExprList.addNode(aELiteral);
                arrayList.add(new AECoercionColumnInfo(aELiteral));
                break;
            }
            case EXTRACT: {
                if (pTListNode.numChildren() != 2) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                object3 = new AEValueExprBuilder(this.getQueryScope());
                object2 = (AEValueExpr)((AEBuilderBase)object3).build((PTLiteralNode)pTListNode.getChild(0));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                object2 = (AEValueExpr)((AEBuilderBase)object3).build(pTListNode.getChild(1));
                aEValueExprList.addNode(object2);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object2));
                break;
            }
            default: {
                if (0 >= pTListNode.numChildren()) break;
                object3 = new AEValueExprBuilder(this.getQueryScope());
                for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                    AEValueExpr aEValueExpr = (AEValueExpr)((AEBuilderBase)object3).build(iPTNode);
                    aEValueExprList.addNode(aEValueExpr);
                    arrayList.add(new AECoercionColumnInfo(aEValueExpr));
                }
            }
        }
        object3 = AEScalarFnMetadataFactory.getInstance();
        object2 = ((AEScalarFnMetadataFactory)object3).createMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        if (string.equalsIgnoreCase("CAST")) {
            AECastFn aECastFn = new AECastFn(string, scalarFunctionID, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getColumnMetadata(), aEValueExprList, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getExpectedArgumentMetadata(), (AEScalarFnMetadataFactory)object3, this.m_dataEngine.getContext(), string2);
        } else {
            AEScalarFn aEScalarFn = new AEScalarFn(string, scalarFunctionID, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getColumnMetadata(), aEValueExprList, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object2).getExpectedArgumentMetadata(), (AEScalarFnMetadataFactory)object3, this.m_dataEngine.getContext());
        }
        arrayList.clear();
        Iterator iterator = var9_15.getArguments().getChildItr();
        while (iterator.hasNext()) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)iterator.next()));
        }
        ((AEScalarFnMetadataFactory)object3).validateMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        return var9_15;
    }

    private boolean IsCastFunctionWithFormatClause(String string, PTListNode pTListNode) throws ErrorException {
        IPTNode iPTNode;
        return string.equalsIgnoreCase("CAST") && (iPTNode = pTListNode.getChild(pTListNode.numChildren() - 1)) instanceof PTLiteralNode && ((PTLiteralNode)iPTNode).getLiteralType() == PTLiteralType.CAST_FORMAT;
    }

    static {
        TreeMap<String, Map<Integer, ScalarFunctionID>> treeMap = new TreeMap<String, Map<Integer, ScalarFunctionID>>(String.CASE_INSENSITIVE_ORDER);
        for (ScalarFunctionID scalarFunctionID : ScalarFunctionID.values()) {
            Map<Integer, ScalarFunctionID> map = treeMap.get(scalarFunctionID.getName());
            if (null == map) {
                map = new HashMap<Integer, ScalarFunctionID>();
                treeMap.put(scalarFunctionID.getName(), map);
            }
            map.put(scalarFunctionID.getArguments().size(), scalarFunctionID);
        }
        SCALAR_FN_LOOKUP = treeMap;
    }
}

