/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.arrow;

import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.TimestampTz;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BigIntVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BitVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.DateDayVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.FieldVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.Float4Vector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.Float8Vector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.IntVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.SmallIntVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.TimeStampMicroTZVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.TinyIntVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VarBinaryVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.VarCharVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableBitHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableDateDayHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableFloat4Holder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableFloat8Holder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableIntHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableSmallIntHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.TimeZone;

public class ArrowDataRetrievers {
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final int MICROS_PER_SECOND = 1000000;
    private static final int NANOS_PER_MICRO = 1000;
    private NullableBigIntHolder m_bigIntHolder = new NullableBigIntHolder();
    private NullableBitHolder m_bitHolder = new NullableBitHolder();
    private NullableFloat8Holder m_doubleHolder = new NullableFloat8Holder();
    private NullableDateDayHolder m_dateDayHolder = new NullableDateDayHolder();
    private NullableIntHolder m_intHolder = new NullableIntHolder();
    private NullableFloat4Holder m_realHolder = new NullableFloat4Holder();
    private NullableSmallIntHolder m_smallIntHolder = new NullableSmallIntHolder();
    private NullableTimeStampMicroTZHolder m_timestampHolder = new NullableTimeStampMicroTZHolder();
    private NullableTinyIntHolder m_tinyIntHolder = new NullableTinyIntHolder();
    public boolean m_useUTF8ForDecoding = true;
    public ILogger m_logger = null;

    public ArrowDataRetrievers(ILogger iLogger, boolean bl) {
        this.m_logger = iLogger;
        this.m_useUTF8ForDecoding = bl;
    }

    public byte[] getBinary(FieldVector fieldVector, int n) throws ErrorException {
        if (fieldVector instanceof VarBinaryVector) {
            return ((VarBinaryVector)fieldVector).get(n);
        }
        throw this.createIncorrectTypeException("Binary", fieldVector.getField().getName());
    }

    public String getString(FieldVector fieldVector, int n) throws ErrorException {
        if (fieldVector instanceof VarCharVector) {
            VarCharVector varCharVector = (VarCharVector)fieldVector;
            if (!varCharVector.isNull(n)) {
                if (this.m_useUTF8ForDecoding) {
                    try {
                        return new String(varCharVector.get(n), StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {
                        LogUtilities.logWarning("Error getting string data as UTF-8 charset: " + exception.getLocalizedMessage(), this.m_logger);
                        return new String(varCharVector.get(n));
                    }
                }
                return new String(varCharVector.get(n));
            }
            return null;
        }
        throw this.createIncorrectTypeException("String", fieldVector.getField().getName());
    }

    public void setBigInt(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof BigIntVector) {
            ((BigIntVector)fieldVector).get(n, this.m_bigIntHolder);
            if (1 == this.m_bigIntHolder.isSet) {
                dataWrapper.setBigInt(this.m_bigIntHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("BigInt", fieldVector.getField().getName());
        }
    }

    public void setBoolean(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof BitVector) {
            ((BitVector)fieldVector).get(n, this.m_bitHolder);
            if (1 == this.m_bitHolder.isSet) {
                dataWrapper.setBoolean(1 == this.m_bitHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Bit", fieldVector.getField().getName());
        }
    }

    public void setDate(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof DateDayVector) {
            ((DateDayVector)fieldVector).get(n, this.m_dateDayHolder);
            if (1 == this.m_dateDayHolder.isSet) {
                dataWrapper.setDate(Date.valueOf(LocalDate.ofEpochDay(this.m_dateDayHolder.value)));
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Date", fieldVector.getField().getName());
        }
    }

    public void setDouble(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof Float8Vector) {
            ((Float8Vector)fieldVector).get(n, this.m_doubleHolder);
            if (1 == this.m_doubleHolder.isSet) {
                dataWrapper.setDouble(this.m_doubleHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Float8", fieldVector.getField().getName());
        }
    }

    public void setInteger(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof IntVector) {
            ((IntVector)fieldVector).get(n, this.m_intHolder);
            if (1 == this.m_intHolder.isSet) {
                dataWrapper.setInteger(this.m_intHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Int", fieldVector.getField().getName());
        }
    }

    public void setReal(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof Float4Vector) {
            ((Float4Vector)fieldVector).get(n, this.m_realHolder);
            if (1 == this.m_realHolder.isSet) {
                dataWrapper.setReal(this.m_realHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Float4", fieldVector.getField().getName());
        }
    }

    public void setSmallInt(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof SmallIntVector) {
            ((SmallIntVector)fieldVector).get(n, this.m_smallIntHolder);
            if (1 == this.m_smallIntHolder.isSet) {
                dataWrapper.setSmallInt(this.m_smallIntHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("SmallInt", fieldVector.getField().getName());
        }
    }

    public void setTimestamp(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof TimeStampMicroTZVector) {
            ((TimeStampMicroTZVector)fieldVector).get(n, this.m_timestampHolder);
            if (1 == this.m_timestampHolder.isSet) {
                TimestampTz timestampTz = this.getTimestampFromRetrievedValue();
                dataWrapper.setTimestamp(timestampTz.getAdjustedTimestamp());
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("Timestamp", fieldVector.getField().getName());
        }
    }

    public void setTinyInt(short s, FieldVector fieldVector, int n, DataWrapper dataWrapper) throws ErrorException {
        if (fieldVector instanceof TinyIntVector) {
            ((TinyIntVector)fieldVector).get(n, this.m_tinyIntHolder);
            if (1 == this.m_tinyIntHolder.isSet) {
                dataWrapper.setTinyInt(this.m_tinyIntHolder.value);
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            throw this.createIncorrectTypeException("TinyInt", fieldVector.getField().getName());
        }
    }

    protected TimestampTz getTimestampFromRetrievedValue() {
        long l = Math.floorDiv(this.m_timestampHolder.value, 1000000L);
        int n = (int)Math.floorMod(this.m_timestampHolder.value, 1000000L);
        TimestampTz timestampTz = new TimestampTz(l * 1000L, n * 1000, UTC_CALENDAR);
        return timestampTz;
    }

    private ErrorException createIncorrectTypeException(String string, String string2) {
        return HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_INCORRECT_VECTOR_TYPE.name(), new String[]{string, string2});
    }
}

