/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWECryptoParts;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEEncrypter;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.KeyLengthException;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.AAD;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.AlgorithmSupportMessage;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.ContentCryptoProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.DirectCryptoProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.JWEHeaderValidation;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetSequenceKey;
import com.databricks.client.jdbc42.internal.nimbusjose.util.Base64URL;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, aad, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

