/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.memory;

import com.databricks.client.jdbc42.internal.slf4j.Logger;
import com.databricks.client.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

final class CheckAllocator {
    private static final Logger logger = LoggerFactory.getLogger(CheckAllocator.class);
    private static final String ALLOCATOR_PATH_CORE = "com/databricks/client/jdbc42/internal/apache/arrow/memory/DefaultAllocationManagerFactory.class";
    private static final String ALLOCATOR_PATH_UNSAFE = "com/databricks/client/jdbc42/internal/apache/arrow/memory/unsafe/DefaultAllocationManagerFactory.class";
    private static final String ALLOCATOR_PATH_NETTY = "com/databricks/client/jdbc42/internal/apache/arrow/memory/netty/DefaultAllocationManagerFactory.class";

    private CheckAllocator() {
    }

    static String check() {
        Set<URL> urls = CheckAllocator.scanClasspath();
        URL rootAllocator = CheckAllocator.assertOnlyOne(urls);
        CheckAllocator.reportResult(rootAllocator);
        if (rootAllocator.getPath().contains("memory-core") || rootAllocator.getPath().contains("/com/databricks/client/jdbc42/internal/apache/arrow/memory/core/")) {
            return "com.databricks.client.jdbc42.internal.apache.arrow.memory.DefaultAllocationManagerFactory";
        }
        if (rootAllocator.getPath().contains("memory-unsafe") || rootAllocator.getPath().contains("/com/databricks/client/jdbc42/internal/apache/arrow/memory/unsafe/")) {
            return "com.databricks.client.jdbc42.internal.apache.arrow.memory.unsafe.DefaultAllocationManagerFactory";
        }
        if (rootAllocator.getPath().contains("memory-netty") || rootAllocator.getPath().contains("/com/databricks/client/jdbc42/internal/apache/arrow/memory/netty/")) {
            return "com.databricks.client.jdbc42.internal.apache.arrow.memory.netty.DefaultAllocationManagerFactory";
        }
        throw new IllegalStateException("Unknown allocation manager type to infer. Current: " + rootAllocator.getPath());
    }

    private static Set<URL> scanClasspath() {
        LinkedHashSet<URL> allocatorPathSet = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> paths;
            ClassLoader allocatorClassLoader = CheckAllocator.class.getClassLoader();
            if (allocatorClassLoader == null) {
                paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_CORE);
                if (!paths.hasMoreElements()) {
                    paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_UNSAFE);
                }
                if (!paths.hasMoreElements()) {
                    paths = ClassLoader.getSystemResources(ALLOCATOR_PATH_NETTY);
                }
            } else {
                paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_CORE);
                if (!paths.hasMoreElements()) {
                    paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_UNSAFE);
                }
                if (!paths.hasMoreElements()) {
                    paths = allocatorClassLoader.getResources(ALLOCATOR_PATH_NETTY);
                }
            }
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                allocatorPathSet.add(path);
            }
        }
        catch (IOException ioe) {
            logger.error("Error getting resources from path", ioe);
        }
        return allocatorPathSet;
    }

    private static void reportResult(URL rootAllocator) {
        String path = rootAllocator.getPath();
        String subPath = path.substring(path.indexOf("memory"));
        logger.info("Using DefaultAllocationManager at {}", (Object)subPath);
    }

    private static URL assertOnlyOne(Set<URL> urls) {
        if (urls.size() > 1) {
            logger.warn("More than one DefaultAllocationManager on classpath. Choosing first found");
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("No DefaultAllocationManager found on classpath. Can't allocate Arrow buffers. Please consider adding arrow-memory-netty or arrow-memory-unsafe as a dependency.");
        }
        return urls.iterator().next();
    }
}

