/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class BitBooleanJDBCDataSink
extends ConvertingJDBCDataSink {
    public BitBooleanJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected abstract void doSet(Boolean var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Boolean) {
            this.doSet((Boolean)object);
        } else if (object instanceof Number) {
            this.doSet(((Number)object).doubleValue() != 0.0);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(bl);
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(by != 0);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(s != 0);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(n != 0);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(l != 0L);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(f != 0.0f);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setBoolean(d != 0.0);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setBoolean(!bigDecimal.equals(BigDecimal.ZERO));
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            this.setBoolean(NonTrivialJDBCConversions.stringToBoolean(string));
        }
    }
}

