/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import java.nio.charset.StandardCharsets;

public class Field {
    public byte[] buffer = null;
    public int position = 0;
    public int length = 0;

    public Field() {
    }

    public Field(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.buffer = bytes;
        this.position = 0;
        this.length = this.buffer.length;
    }

    public Field(byte[] buffer, int position, int length) {
        this.set(buffer, position, length);
    }

    public final void set(byte[] buffer, int position, int length) {
        this.buffer = buffer;
        this.position = position;
        this.length = length;
    }

    public void set(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
        this.length = buffer.length;
    }

    public boolean isNull() {
        return this.buffer == null || this.length == 0;
    }

    public void reset() {
        this.buffer = null;
        this.length = 0;
    }

    public byte byteAt(int i) {
        return this.buffer[this.position + i];
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += this.buffer[this.position + i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Field)) {
            return false;
        }
        Field o = (Field)obj;
        if (o.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (o.buffer[o.position + i] == this.buffer[this.position + i]) continue;
            return false;
        }
        return true;
    }

    public Field copy() {
        byte[] copy = null;
        if (this.buffer != null) {
            copy = new byte[this.length];
            System.arraycopy(this.buffer, this.position, copy, 0, this.length);
        }
        return new Field(copy, 0, this.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.position; i < this.position + this.length; ++i) {
            sb.append((char)this.buffer[i]);
        }
        return sb.toString();
    }

    public void copyFrom(Field f) {
        if (f.buffer == null || f.length == 0) {
            this.buffer = null;
            this.length = 0;
            this.position = 0;
            return;
        }
        if (this.buffer == null || f.length > this.buffer.length) {
            this.buffer = new byte[f.length];
        }
        System.arraycopy(f.buffer, f.position, this.buffer, 0, f.length);
        this.position = 0;
        this.length = f.length;
    }
}

