/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.ProtocolParser;
import com.crankuptheamps.client.XMLMessage;
import com.crankuptheamps.client.XMLProtocol;
import com.crankuptheamps.client.exception.StreamException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class XMLProtocolParser
implements ProtocolParser {
    private static final Charset LATIN1 = StandardCharsets.ISO_8859_1;
    private static byte[] HEADER = null;
    private static byte[] BODY = null;
    private static byte[] BODY_TERMINAL = null;
    private static byte[] BODY_EMPTY = null;
    private XMLMessage message = null;
    private ByteBuffer buffer = null;
    private int remainingBytes = 0;
    private StreamState state;
    private static byte[] SOW_KEYID;
    private static byte[] SOW_LEN;
    private static byte[] SOW_TS;
    private static byte[] SOW_X;
    private static byte DBL_QUOTE;
    private static byte GREATER_THAN;

    public XMLProtocolParser(XMLProtocol messageType) {
        this.message = messageType.allocateMessage();
    }

    @Override
    public void process(ByteBuffer buffer, int remainingBytes, MessageHandler listener) throws StreamException {
        this.buffer = buffer;
        this.remainingBytes = remainingBytes;
        this.state = StreamState.start;
        this.message.reset();
        this.message.setBuffer(buffer.array());
        while (this.read(this.message)) {
            listener.invoke(this.message);
        }
    }

    private final HeaderField extractHeaderField() {
        if (this.remainingBytes < 5 || this.getByte() != 60) {
            return HeaderField.UNKNOWN;
        }
        int length = 0;
        int start = this.buffer.position();
        while (this.remainingBytes > 0 && this.getByte() != 62) {
            ++length;
        }
        switch (this.peekByte(start)) {
            case 65: {
                if (length == 6) {
                    return HeaderField.AckTyp;
                }
                return HeaderField.UNKNOWN;
            }
            case 66: {
                if (length == 5) {
                    return HeaderField.BkMrk;
                }
                if (length != 6) {
                    return HeaderField.UNKNOWN;
                }
                if (this.peekByte(start + 4) == 83) {
                    return HeaderField.BtchSz;
                }
                return HeaderField.UNKNOWN;
            }
            case 67: {
                switch (length) {
                    case 3: {
                        return HeaderField.Cmd;
                    }
                    case 5: {
                        switch (this.peekByte(start + 1)) {
                            case 109: {
                                return HeaderField.CmdId;
                            }
                            case 114: {
                                return HeaderField.CrlId;
                            }
                        }
                        return HeaderField.UNKNOWN;
                    }
                    case 8: {
                        return HeaderField.ClntName;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 68: {
                switch (length) {
                    case 5: {
                        return HeaderField.DlvMd;
                    }
                    case 6: {
                        return HeaderField.Drblty;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 69: {
                if (length == 4) {
                    this.advance(length);
                    return HeaderField.Expn;
                }
                return HeaderField.UNKNOWN;
            }
            case 70: {
                if (length == 4) {
                    return HeaderField.Fltr;
                }
                return HeaderField.UNKNOWN;
            }
            case 71: {
                switch (length) {
                    case 6: {
                        return HeaderField.GrcPrd;
                    }
                    case 8: {
                        return HeaderField.GrpSqNum;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 72: {
                if (length == 4) {
                    return HeaderField.Hrtbt;
                }
                return HeaderField.UNKNOWN;
            }
            case 76: {
                switch (length) {
                    case 11: {
                        return HeaderField.LeasePeriod;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 77: {
                switch (length) {
                    case 5: {
                        return HeaderField.MsgLn;
                    }
                    case 7: {
                        return HeaderField.Matches;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 79: {
                switch (length) {
                    case 4: {
                        return HeaderField.Opts;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 80: {
                switch (length) {
                    case 2: {
                        return HeaderField.PW;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 81: {
                switch (length) {
                    case 3: {
                        return HeaderField.QId;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 82: {
                switch (length) {
                    case 6: {
                        return HeaderField.Reason;
                    }
                    case 15: {
                        switch (this.peekByte(start + 7)) {
                            case 82: {
                                return HeaderField.RecordsReturned;
                            }
                            case 73: {
                                return HeaderField.RecordsInserted;
                            }
                        }
                        return HeaderField.UNKNOWN;
                    }
                    case 14: {
                        switch (this.peekByte(start + 7)) {
                            case 68: {
                                return HeaderField.RecordsDeleted;
                            }
                            case 85: {
                                return HeaderField.RecordsUpdated;
                            }
                        }
                        return HeaderField.UNKNOWN;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 83: {
                switch (length) {
                    case 3: {
                        return HeaderField.Seq;
                    }
                    case 5: {
                        return HeaderField.SubId;
                    }
                    case 6: {
                        switch (this.peekByte(start + 1)) {
                            case 117: {
                                return HeaderField.SubIds;
                            }
                            case 111: {
                                return HeaderField.SowKey;
                            }
                            case 116: {
                                return HeaderField.Status;
                            }
                        }
                        return HeaderField.UNKNOWN;
                    }
                    case 7: {
                        return HeaderField.SowKeys;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 84: {
                switch (length) {
                    case 3: {
                        return HeaderField.Tpc;
                    }
                    case 4: {
                        return HeaderField.TopN;
                    }
                    case 5: {
                        return HeaderField.Timestamp;
                    }
                    case 7: {
                        return HeaderField.TmIntvl;
                    }
                    case 12: {
                        return HeaderField.TopicMatches;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 85: {
                if (length != 5) {
                    return HeaderField.UNKNOWN;
                }
                switch (this.peekByte(start + 2)) {
                    case 114: {
                        return HeaderField.UsrId;
                    }
                }
                return HeaderField.UNKNOWN;
            }
            case 86: {
                if (length != 7) {
                    return HeaderField.UNKNOWN;
                }
                return HeaderField.Version;
            }
        }
        return HeaderField.UNKNOWN;
    }

    private final char getUnescapedChar(int startPos) {
        switch (this.peekByte(startPos + 1)) {
            case 97: {
                switch (this.peekByte(startPos + 2)) {
                    case 109: {
                        return '&';
                    }
                    case 112: {
                        return '\'';
                    }
                }
            }
            case 108: {
                return '<';
            }
            case 103: {
                return '>';
            }
            case 113: {
                return '\"';
            }
        }
        return '\u0000';
    }

    private final int processEscapeField() {
        int b = this.buffer.position();
        int valueLength = 0;
        while (this.peekByte(this.buffer.position()) != 60) {
            if (this.peekByte(this.buffer.position()) == 38) {
                char unescapedChar = this.getUnescapedChar(this.buffer.position());
                this.buffer.put(b++, (byte)unescapedChar);
                this.advancePast((byte)59);
            } else {
                this.buffer.put(b++, this.getByte());
            }
            ++valueLength;
        }
        return valueLength;
    }

    private final void extractFieldValues(XMLMessage message) {
        HeaderField field = this.extractHeaderField();
        while (field != HeaderField.UNKNOWN) {
            boolean needsEscape = field == HeaderField.Tpc || field == HeaderField.UsrId || field == HeaderField.PW || field == HeaderField.ClntName || field == HeaderField.CrlId || field == HeaderField.SubId || field == HeaderField.SubIds;
            int valueStart = this.buffer.position();
            int valueLength = 0;
            if (needsEscape) {
                valueLength = this.processEscapeField();
            } else {
                while (this.remainingBytes > 0 && this.getByte() != 60) {
                    ++valueLength;
                }
            }
            switch (field) {
                case AckTyp: {
                    message._AckType.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case BtchSz: {
                    message._BatchSize.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case BkMrk: {
                    message._Bookmark.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case ClntName: {
                    message._ClientName.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Cmd: {
                    message._Command.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case CmdId: {
                    message._CommandId.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case CrlId: {
                    message._CorrelationId.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Expn: {
                    message._Expiration.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Fltr: {
                    message._Filter.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case GrpSqNum: {
                    message._GroupSeqNo.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case LeasePeriod: {
                    message._LeasePeriod.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Matches: {
                    message._Matches.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case MsgLn: {
                    message._Length.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Opts: {
                    message._Options.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case PW: {
                    message._Password.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case QId: {
                    message._QueryId.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Reason: {
                    message._Reason.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case RecordsInserted: {
                    message._RecordsInserted.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case RecordsUpdated: {
                    message._RecordsUpdated.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case RecordsReturned: {
                    message._RecordsReturned.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case RecordsDeleted: {
                    message._RecordsDeleted.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Seq: {
                    message._Sequence.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case SubIds: {
                    message._SubIds.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case SowKey: {
                    message._SowKey.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case SowKeys: {
                    message._SowKeys.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Status: {
                    message._Status.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case SubId: {
                    message._SubId.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Timestamp: {
                    message._Timestamp.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Tpc: {
                    message._Topic.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case TopicMatches: {
                    message._TopicMatches.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case TopN: {
                    message._TopN.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case UsrId: {
                    message._UserId.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
                case Version: {
                    message._Version.set(this.buffer.array(), valueStart, valueLength);
                    break;
                }
            }
            while (this.remainingBytes > 0 && this.getByte() != 62) {
            }
            field = this.extractHeaderField();
        }
    }

    private final boolean extractSOWHeaderFields(XMLMessage message) {
        int position = this.advancePast(SOW_KEYID);
        if (position < 0) {
            return false;
        }
        if (this.advancePast(DBL_QUOTE) < 0) {
            return false;
        }
        message._SowKey.set(this.buffer.array(), position, this.buffer.position() - position - 1);
        position = this.advancePast(SOW_LEN);
        if (position < 0) {
            return false;
        }
        if (this.advancePast(DBL_QUOTE) < 0) {
            return false;
        }
        message._Length.set(this.buffer.array(), position, this.buffer.position() - position - 1);
        position = this.buffer.position();
        if (this.peekByte(position + 1) == 116 && this.peekByte(position + 2) == 115) {
            position = this.advancePast(SOW_TS);
            this.advancePast(DBL_QUOTE);
            message._Timestamp.set(this.buffer.array(), position, this.buffer.position() - position - 1);
        }
        if (this.peekByte((position = this.buffer.position()) + 1) == 120 && this.peekByte(position + 2) == 61) {
            position = this.advancePast(SOW_X);
            this.advancePast(DBL_QUOTE);
            message._CorrelationId.set(this.buffer.array(), position, this.buffer.position() - position - 1);
        }
        if (this.advancePast(GREATER_THAN) < 0) {
            return false;
        }
        position = this.buffer.position();
        int len = message.getLength();
        message.setRawBufferLength(position + len - message.getRawBufferOffset());
        message._Data.set(this.buffer.array(), position, len);
        return true;
    }

    private int advancePast(byte[] t) {
        for (int position = this.buffer.position(); position < this.buffer.position() + this.remainingBytes - t.length; ++position) {
            boolean found = true;
            for (int i = 0; i < t.length; ++i) {
                if (this.peekByte(position + i) == t[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.remainingBytes -= (position += t.length) - this.buffer.position();
            this.buffer.position(position);
            return position;
        }
        return -1;
    }

    private int advancePast(byte t) {
        int c = this.remainingBytes;
        while (c-- > 0) {
            if (this.getByte() != t) continue;
            this.remainingBytes = c;
            return this.buffer.position();
        }
        return -1;
    }

    private final void advance(int bytes) {
        this.remainingBytes -= bytes;
        this.buffer.position(this.buffer.position() + bytes);
    }

    private int findBytes(byte[] t) {
        for (int position = this.buffer.position(); position < this.buffer.limit() - t.length; ++position) {
            boolean found = true;
            for (int i = 0; i < t.length; ++i) {
                if (this.peekByte(position + i) == t[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return position;
        }
        return -1;
    }

    private final byte getByte() {
        --this.remainingBytes;
        return this.buffer.get();
    }

    private final byte peekByte(int offset) {
        return this.buffer.get(offset);
    }

    private boolean read(XMLMessage m) throws StreamException {
        if (this.remainingBytes <= 0) {
            return false;
        }
        if (this.state == StreamState.start) {
            m.setRawBufferOffset(this.buffer.position());
            int position = this.advancePast(HEADER);
            if (position < 0) {
                throw new StreamException("stream corruption: couldn't locate XML SOAP header.");
            }
            this.extractFieldValues(m);
            if (m.getCommand() == 8) {
                if (this.advancePast(BODY) < 0) {
                    throw new StreamException("stream corruption: couldn't locate XML SOAP body.");
                }
                if (!this.extractSOWHeaderFields(m)) {
                    throw new StreamException("stream corruption: couldn't locate message segment within XML SOAP body.");
                }
                this.state = StreamState.in_sow;
            } else {
                int bodyStart;
                if (this.advancePast(BODY) < 0) {
                    if (this.advancePast(BODY_EMPTY) >= 0) {
                        position = bodyStart = this.buffer.position();
                    } else {
                        bodyStart = this.buffer.position();
                        position = bodyStart + this.remainingBytes;
                    }
                } else {
                    bodyStart = this.buffer.position();
                    position = this.findBytes(BODY_TERMINAL);
                    if (position < 0) {
                        throw new StreamException("stream corruption: couldn't locate XML SOAP body end.");
                    }
                }
                m.setRawBufferLength(position - m.getRawBufferOffset());
                m._Data.set(this.buffer.array(), bodyStart, position - bodyStart);
                this.state = StreamState.end;
                this.advance(this.remainingBytes);
            }
        } else if (this.state == StreamState.in_sow) {
            if (!this.extractSOWHeaderFields(m)) {
                this.state = StreamState.end;
                this.advance(this.remainingBytes);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    static {
        HEADER = "<SOAP-ENV:Header>".getBytes(LATIN1);
        BODY = "<SOAP-ENV:Body>".getBytes(LATIN1);
        BODY_TERMINAL = "</SOAP-ENV:Body>".getBytes(LATIN1);
        BODY_EMPTY = "<SOAP-ENV:Body/>".getBytes(LATIN1);
        SOW_KEYID = null;
        SOW_LEN = null;
        SOW_TS = null;
        SOW_X = null;
        DBL_QUOTE = 0;
        GREATER_THAN = 0;
        SOW_KEYID = " key=\"".getBytes(LATIN1);
        SOW_LEN = " len=\"".getBytes(LATIN1);
        SOW_TS = " ts=\"".getBytes(LATIN1);
        SOW_X = " x=\"".getBytes(LATIN1);
        DBL_QUOTE = "\"".getBytes(LATIN1)[0];
        GREATER_THAN = ">".getBytes(LATIN1)[0];
    }

    private static enum HeaderField {
        AckTyp,
        BkMrk,
        BtchSz,
        ClntName,
        Cmd,
        CmdId,
        DlvMd,
        Drblty,
        Expn,
        Fltr,
        GrcPrd,
        GrpSqNum,
        Hrtbt,
        LeasePeriod,
        Matches,
        MsgLn,
        Opts,
        PW,
        QId,
        QryIntvl,
        Reason,
        RecordsUpdated,
        RecordsInserted,
        RecordsDeleted,
        RecordsReturned,
        Seq,
        SubIds,
        SowKey,
        SowKeys,
        Status,
        SubId,
        Timestamp,
        TmIntvl,
        Tpc,
        TopicMatches,
        TopN,
        UsrId,
        Version,
        CrlId,
        UNKNOWN;

    }

    private static enum StreamState {
        start,
        in_sow,
        end;

    }
}

