/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import java.util.LinkedList;

public class Pool<T> {
    int _initialSize = 0;
    LinkedList<T> _freePool = new LinkedList();
    Class<T> _theClass;

    public Pool(Class<T> theClass, int initialSize) {
        this._theClass = theClass;
        if (initialSize < 1) {
            initialSize = 1;
        }
        this._initialSize = initialSize;
        this.grow();
    }

    private void grow() {
        for (int i = 0; i < this._initialSize; ++i) {
            try {
                this._freePool.add(this._theClass.newInstance());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to allocate initial object pool.", e);
            }
        }
    }

    public synchronized T get() {
        if (this._freePool.size() < 1) {
            this.grow();
        }
        return this._freePool.removeFirst();
    }

    public synchronized void returnToPool(T theInstance) {
        this._freePool.add(theInstance);
    }
}

