/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.ConnectionStateListener;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.SubscriptionManager;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MessageStream
implements Iterator<Message>,
Iterable<Message>,
MessageHandler,
ConnectionStateListener,
AutoCloseable {
    static final int STATE_Unset = 0;
    static final int STATE_Reading = 16;
    static final int STATE_Subscribed = 17;
    static final int STATE_SOWOnly = 18;
    static final int STATE_StatsOnly = 19;
    static final int STATE_AcksOnly = 19;
    static final int STATE_Disconnected = 1;
    static final int STATE_Complete = 2;
    protected CommandId _commandId;
    protected CommandId _queryId;
    protected CommandId _subId;
    protected Client _client;
    protected ConcurrentLinkedQueue<Message> _q = new ConcurrentLinkedQueue();
    protected HashMap<String, Message> _sowKeyMap = null;
    protected Lock _sowKeyLock = new ReentrantLock();
    protected Message _current = null;
    protected volatile int _state = 0;
    protected int _timeout = 0;
    protected boolean _timedOut = false;
    protected volatile int _maxDepth = Integer.MAX_VALUE;
    protected int _requestedAcks = 0;
    protected Field _previousTopic = new Field();
    protected Field _previousBookmark = new Field();
    private static MessageStream _emptyMessageStream = new MessageStream();

    private MessageStream() {
        this._commandId = null;
        this._queryId = null;
        this._subId = null;
        this._client = null;
        this._state = 2;
        this._requestedAcks = 0;
    }

    public static MessageStream getEmptyMessageStream() {
        return _emptyMessageStream;
    }

    protected MessageStream(Client client_) {
        this._client = client_;
        this._client.addConnectionStateListener(this);
    }

    protected void setSubscription(CommandId subId_) {
        SubscriptionManager subMgr;
        this._subId = subId_;
        if (this._client != null && (subMgr = this._client.getSubscriptionManager()) != null) {
            subMgr.unsubscribe(this._subId);
        }
        this.setState(17);
    }

    protected void setQueryId(CommandId queryId_) {
        if (!(this._queryId != null || this._commandId != null && this._commandId.equals(queryId_))) {
            this._queryId = queryId_;
        }
    }

    protected void setCommandId(CommandId commandId_) {
        if (this._commandId == null) {
            this._commandId = commandId_;
        }
    }

    protected void setSOWOnly() {
        this.setState(18);
    }

    protected void setStatsOnly() {
        this.setState(19);
        this._requestedAcks = 32;
    }

    protected void setAcksOnly(CommandId commandId_, int ackTypes_) {
        this.setState(19);
        this._commandId = commandId_;
        this._requestedAcks = ackTypes_;
    }

    protected void setRunning() {
        this.setState(16);
    }

    public MessageStream timeout(int timeout_) {
        this._timeout = timeout_;
        return this;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public MessageStream conflate() {
        if (this._sowKeyMap == null) {
            this._sowKeyMap = new HashMap();
        }
        return this;
    }

    public boolean isConflating() {
        return this._sowKeyMap != null;
    }

    public MessageStream maxDepth(int maxDepth_) {
        this._maxDepth = maxDepth_;
        return this;
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    public int getDepth() {
        return this._q.size();
    }

    @Override
    public void connectionStateChanged(int newState_) {
        if (newState_ == 0) {
            this.setState(1);
            this.close();
        }
    }

    private void setState(int state_) {
        if (this._state != 1) {
            this._state = state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        if (this._client != null && !this._previousTopic.isNull() && !this._previousBookmark.isNull()) {
            try {
                this._client._ack(this._previousTopic, this._previousBookmark);
            }
            catch (AMPSException e) {
                this._current = null;
                this._timedOut = false;
                var2_4 = false;
                return var2_4;
            }
            finally {
                this._previousTopic.reset();
                this._previousBookmark.reset();
            }
        }
        this._timedOut = false;
        if (this._current != null) {
            return true;
        }
        this._current = this._q.poll();
        if (this._current != null) {
            return true;
        }
        if (this._timeout == 0) {
            while ((this._state & 16) != 0 && this._current == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    this._timedOut = true;
                    return true;
                }
                if (this._sowKeyMap != null) {
                    this._sowKeyLock.lock();
                    try {
                        this._current = this._q.poll();
                        if (this._current == null) continue;
                        this._sowKeyMap.remove(this._current.getSowKey());
                        continue;
                    }
                    finally {
                        this._sowKeyLock.unlock();
                        continue;
                    }
                }
                this._current = this._q.poll();
            }
            return this._current != null;
        }
        startTime = System.currentTimeMillis();
        while ((this._state & 16) != 0 && this._current == null && !this._timedOut) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                this._timedOut = true;
                return true;
            }
            if (this._sowKeyMap != null) {
                this._sowKeyLock.lock();
                try {
                    this._current = this._q.poll();
                    if (this._current == null) ** GOTO lbl63
                    this._sowKeyMap.remove(this._current.getSowKey());
                }
                finally {
                    this._sowKeyLock.unlock();
                }
            } else {
                this._current = this._q.poll();
            }
lbl63:
            // 3 sources

            if (this._current != null) continue;
            this._timedOut = System.currentTimeMillis() - startTime > (long)this._timeout;
        }
        if (this._sowKeyMap != null && this._current != null) {
            this._sowKeyMap.remove(this._current.getSowKey());
        }
        return (this._state & 16) != 0 && this._timedOut != false || this._current != null;
    }

    @Override
    public Message next() {
        if (this._timedOut) {
            this._timedOut = false;
            return null;
        }
        if (this._current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Message retVal = this._current;
        this._current = null;
        if (retVal != null) {
            int command = retVal.getCommand();
            if (this._state == 18 && command == 16384) {
                this.setState(2);
                if (this._client == null) {
                    this._commandId = null;
                    this._queryId = null;
                    this._subId = null;
                } else {
                    this._client.removeConnectionStateListener(this);
                    if (this._commandId != null) {
                        this._client.removeMessageHandler(this._commandId);
                        this._commandId = null;
                    }
                    if (this._queryId != null) {
                        this._client.removeMessageHandler(this._queryId);
                        this._queryId = null;
                    }
                    if (this._subId != null) {
                        this._client.removeMessageHandler(this._subId);
                        this._subId = null;
                    }
                }
            } else if (this._state == 19 && command == 65536) {
                this._requestedAcks &= ~retVal.getAckType();
                if (this._requestedAcks == 0) {
                    this.setState(2);
                    if (this._client == null) {
                        this._commandId = null;
                        this._queryId = null;
                        this._subId = null;
                    } else {
                        this._client.removeConnectionStateListener(this);
                        if (this._commandId != null) {
                            this._client.removeMessageHandler(this._commandId);
                            this._commandId = null;
                        }
                        if (this._queryId != null) {
                            this._client.removeMessageHandler(this._queryId);
                            this._queryId = null;
                        }
                        if (this._subId != null) {
                            this._client.removeMessageHandler(this._subId);
                            this._subId = null;
                        }
                    }
                }
            } else if (command == 1 && this._client != null && this._client.getAutoAck() && !retVal.isBookmarkNull() && !retVal.isLeasePeriodNull()) {
                this._previousTopic = retVal.getTopicRaw().copy();
                this._previousBookmark = retVal.getBookmarkRaw().copy();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Message message) {
        if (this._sowKeyMap != null && message.getSowKeyRaw().length > 0) {
            String sowKey = message.getSowKey();
            Message prevMessage = null;
            this._sowKeyLock.lock();
            try {
                prevMessage = this._sowKeyMap.get(sowKey);
                if (prevMessage != null) {
                    message._copyTo(prevMessage);
                    this._sowKeyLock.unlock();
                }
            }
            finally {
                this._sowKeyLock.unlock();
            }
            if (prevMessage == null) {
                while (this._q.size() > this._maxDepth) {
                    try {
                        if (this._client != null) {
                            this._client.checkAndSendHeartbeat(false);
                        }
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Message newMessage = message.copy();
                this._sowKeyMap.put(sowKey, newMessage);
                this._q.add(newMessage);
            }
        } else {
            while (this._q.size() > this._maxDepth) {
                try {
                    if (this._client != null) {
                        this._client.checkAndSendHeartbeat(false);
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._q.add(message.copy());
        }
        message.setIgnoreAutoAck();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }

    public boolean isConnected() {
        return this._state != 1;
    }

    @Override
    public void close() {
        if (this._client == null) {
            this._commandId = null;
            this._queryId = null;
            this._subId = null;
        } else {
            this._client.removeConnectionStateListener(this);
            if (this._commandId != null) {
                if (this._state == 17) {
                    try {
                        this._client.unsubscribe(this._commandId);
                    }
                    catch (AMPSException e) {
                        this._client.absorbedException(e);
                    }
                } else {
                    this._client.removeMessageHandler(this._commandId);
                }
                this._commandId = null;
            }
            if (this._queryId != null) {
                if (this._state >= 2) {
                    try {
                        this._client.unsubscribe(this._queryId);
                    }
                    catch (AMPSException e) {
                        this._client.absorbedException(e);
                    }
                } else {
                    this._client.removeMessageHandler(this._queryId);
                }
                this._queryId = null;
            }
            if (this._subId != null) {
                if (this._state >= 2) {
                    try {
                        this._client.unsubscribe(this._subId);
                    }
                    catch (AMPSException e) {
                        this._client.absorbedException(e);
                    }
                } else {
                    this._client.removeMessageHandler(this._subId);
                }
                this._subId = null;
            }
        }
        this.setState(2);
    }
}

