/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.SubscriptionManager;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.StringField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MemorySubscriptionManager
implements SubscriptionManager {
    static long DefaultResubscriptionTimeout = 0L;
    long _resubscriptionTimeout = 0L;
    private final Lock _lock = new ReentrantLock();
    private final Condition _resubscriptionStatus = this._lock.newCondition();
    private HashMap<Field, SubscriptionInfo> _active = new HashMap();
    private HashMap<Field, SubscriptionInfo> _resumed = new HashMap();
    private ArrayList<SubscriptionInfo> _resumeList = new ArrayList();
    volatile boolean _resubscribing = false;

    public MemorySubscriptionManager() {
        this._resubscriptionTimeout = DefaultResubscriptionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(MessageHandler messageHandler, Message message) {
        this._lock.lock();
        try {
            while (this._resubscribing) {
                try {
                    this._resubscriptionStatus.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!message.isSubIdNull()) {
                String subId = message.getSubId();
                if (!message.isOptionsNull()) {
                    String options = message.getOptions();
                    if (options.contains("resume")) {
                        SubscriptionInfo subInfo = new SubscriptionInfo(messageHandler, message, this);
                        boolean saved = false;
                        for (String sid : subId.split(",")) {
                            Field sidField = new Field(sid);
                            if (this._resumed.containsKey(sidField)) continue;
                            this._resumed.put(sidField, subInfo);
                            saved = true;
                        }
                        if (saved) {
                            this._resumeList.add(subInfo);
                        }
                        return;
                    }
                    if (options.contains("pause")) {
                        for (String sid : subId.split(",")) {
                            MessageHandler handler = messageHandler;
                            Field sidField = new Field(sid);
                            SubscriptionInfo existingSubInfo = this._resumed.get(sidField);
                            if (existingSubInfo != null) {
                                if (existingSubInfo.removeSubId(sidField)) {
                                    this._resumeList.remove(existingSubInfo);
                                }
                                this._resumed.remove(sidField);
                            }
                            if ((existingSubInfo = this._active.get(sidField)) != null) {
                                if (!options.contains("replace")) {
                                    existingSubInfo.pause();
                                    continue;
                                }
                                handler = existingSubInfo._handler;
                            }
                            Message m = message.copy();
                            m.setSubId(sid);
                            SubscriptionInfo subInfo = new SubscriptionInfo(handler, m, this);
                            this._active.put(subInfo._subId, subInfo);
                        }
                        return;
                    }
                }
                MessageHandler handler = messageHandler;
                Field sidField = new Field(subId);
                SubscriptionInfo existingSubInfo = this._active.get(sidField);
                if (existingSubInfo != null) {
                    handler = existingSubInfo._handler;
                }
                SubscriptionInfo subInfo = new SubscriptionInfo(handler, message, this);
                this._active.put(subInfo._subId, subInfo);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(CommandId subId) {
        this._lock.lock();
        try {
            while (this._resubscribing) {
                try {
                    this._resubscriptionStatus.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            StringField f = new StringField();
            f.setValue(subId);
            this._active.remove(f);
            SubscriptionInfo existingSubInfo = this._resumed.get(f);
            if (existingSubInfo != null) {
                if (existingSubInfo.removeSubId(f)) {
                    this._resumeList.remove(existingSubInfo);
                }
                this._resumed.remove(f);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void clear() {
        this._lock.lock();
        try {
            while (this._resubscribing) {
                try {
                    this._resubscriptionStatus.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._active.clear();
            this._resumed.clear();
            this._resumeList.clear();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resubscribe(Client client) throws AMPSException {
        ArrayList<SubscriptionInfo> subs = null;
        try {
            this._lock.lock();
            try {
                subs = new ArrayList<SubscriptionInfo>(this._active.size());
                this._resubscribing = true;
                for (SubscriptionInfo si : this._active.values()) {
                    subs.add(si);
                }
                for (SubscriptionInfo si : this._resumeList) {
                    subs.add(si);
                }
            }
            finally {
                this._lock.unlock();
            }
            for (SubscriptionInfo si : subs) {
                si.resubscribe(client);
            }
        }
        finally {
            this._resubscribeDone();
        }
    }

    private void _resubscribeDone() {
        this._lock.lock();
        try {
            this._resubscribing = false;
            this._resubscriptionStatus.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    public static void setDefaultResubscriptionTimeout(long timeout) {
        DefaultResubscriptionTimeout = timeout;
    }

    public static long getDefaultResubscriptionTimeout() {
        return DefaultResubscriptionTimeout;
    }

    public void setResubscriptionTimeout(long timeout) {
        this._resubscriptionTimeout = timeout;
    }

    public long getResubscriptionTimeout() {
        return this._resubscriptionTimeout;
    }

    static class SubscriptionInfo {
        public MessageHandler _handler;
        Field _recent;
        Field _subId;
        String _options;
        boolean _hasBookmark;
        String _filter;
        String _orderBy;
        String _queryId;
        String _sowKeys;
        String _topic;
        long _topN;
        int _command;
        int _ackType;
        int _batchSize;
        MemorySubscriptionManager _parent;

        SubscriptionInfo(MessageHandler messageHandler, Message message, MemorySubscriptionManager parent) {
            this._handler = messageHandler;
            this.saveMessage(message);
            byte[] recentBuf = new byte[512];
            this._recent = new Field(recentBuf, 0, 0);
            this._parent = parent;
        }

        void resubscribe(Client client) throws AMPSException {
            if (this._options != null) {
                this._options = this._options.replaceAll("replace,?", "");
                if (this._options.length() < 2) {
                    this._options = null;
                }
            }
            Message message = client.allocateMessage();
            if (this._hasBookmark) {
                if (this.isPaused() && this._recent.length > 0) {
                    message.setBookmark(this._recent.buffer, this._recent.position, this._recent.length);
                } else {
                    Field recent = client.getBookmarkStore().getMostRecent(this._subId);
                    message.setBookmark(recent.buffer, recent.position, recent.length);
                }
            }
            this.apply(message);
            client.send(this._handler, message, this._parent._resubscriptionTimeout);
            this._recent.length = 0;
        }

        boolean removeSubId(Field subId_) {
            int subIdStart = subId_.position;
            int subIdLen = subId_.length;
            while (subId_.buffer[subIdStart + subIdLen - 1] == 44) {
                --subIdLen;
            }
            while (subId_.buffer[subIdStart] == 44) {
                ++subIdStart;
                --subIdLen;
            }
            if (subIdLen > this._subId.length) {
                return this._subId.isNull();
            }
            boolean match = true;
            int matchStart = 0;
            int matchCount = 0;
            for (int i = 0; i < this._subId.length; ++i) {
                if (this._subId.buffer[this._subId.position + i] == 44) {
                    if (matchCount == subIdLen) break;
                    matchStart = i + 1;
                    matchCount = 0;
                    match = true;
                    continue;
                }
                if (!match) continue;
                if (matchCount < subIdLen && this._subId.buffer[this._subId.position + i] == subId_.buffer[subIdStart + matchCount]) {
                    ++matchCount;
                    continue;
                }
                matchCount = 0;
                match = false;
            }
            if (match && matchCount == subIdLen) {
                int len = this._subId.length - matchCount;
                if (len > 1) {
                    byte[] buffer = new byte[len];
                    int offset = 0;
                    int newLen = 0;
                    for (int i = 0; i + offset < this._subId.length && (i != matchStart || i + (offset = matchCount) < this._subId.length && (this._subId.buffer[this._subId.position + offset + i] != 44 || ++offset + i < this._subId.length)); ++i) {
                        buffer[i] = this._subId.buffer[this._subId.position + offset + i];
                        ++newLen;
                    }
                    if (newLen > 0) {
                        this._subId = new Field(buffer, 0, newLen);
                        return false;
                    }
                }
                this._subId.reset();
                return true;
            }
            return this._subId.isNull();
        }

        void pause() {
            if (this.isPaused()) {
                return;
            }
            this._options = this._options == null ? "pause" : "pause," + this._options;
        }

        Field getMostRecent(Client client) throws AMPSException {
            if (!this._recent.isNull()) {
                return this._recent;
            }
            Field subId = new Field();
            int start = 0;
            while (this._subId.buffer[this._subId.position + start] == 44) {
                ++start;
            }
            for (int end = start + 1; end < this._subId.length; ++end) {
                if (this._subId.buffer[this._subId.position + end] != 44) continue;
                subId.set(this._subId.buffer, this._subId.position + start, end - start);
                Field mostRecent = client.getBookmarkStore().getMostRecent(subId);
                if (this._recent.length > 0) {
                    if (this._recent.length == this._recent.buffer.length) {
                        byte[] newRecent = new byte[this._recent.buffer.length + 512];
                        System.arraycopy(this._recent.buffer, 0, newRecent, 0, this._recent.length);
                        this._recent.set(newRecent, 0, this._recent.length);
                    }
                    this._recent.buffer[this._recent.length++] = 44;
                }
                if (this._recent.length + mostRecent.length > this._recent.buffer.length) {
                    int newSize;
                    for (newSize = this._recent.buffer.length + 512; this._recent.length + mostRecent.length > newSize; newSize += 512) {
                    }
                    byte[] newRecent = new byte[newSize];
                    System.arraycopy(this._recent.buffer, 0, newRecent, 0, this._recent.length);
                    this._recent.set(newRecent, 0, this._recent.length);
                }
                System.arraycopy(mostRecent.buffer, mostRecent.position, this._recent.buffer, this._recent.length, mostRecent.length);
                this._recent.length += mostRecent.length;
                while (end < this._subId.length && this._subId.buffer[this._subId.position + end] == 44) {
                    ++end;
                }
                start = end;
            }
            return this._recent;
        }

        final void saveMessage(Message message) {
            this._subId = message.getSubIdRaw().copy();
            this._options = message.getOptions();
            this._hasBookmark = !message.isBookmarkNull();
            this._filter = message.getFilter();
            this._orderBy = message.getOrderBy();
            this._queryId = message.getQueryId();
            this._sowKeys = message.getSowKeys();
            this._topic = message.getTopic();
            this._ackType = message.getAckTypeOutgoing();
            this._command = message.getCommand();
            this._batchSize = !message.isBatchSizeNull() ? message.getBatchSize() : 1;
            this._topN = !message.isTopNNull() ? message.getTopN() : -1L;
        }

        void apply(Message message) {
            message.setSubId(this._subId.buffer, 0, this._subId.length);
            message.setOptions(this._options);
            message.setFilter(this._filter);
            message.setOrderBy(this._orderBy);
            message.setQueryId(this._queryId);
            message.setSowKeys(this._sowKeys);
            message.setTopic(this._topic);
            message.setAckType(this._ackType);
            message.setCommand(this._command);
            message.setBatchSize(this._batchSize);
            if (this._topN != -1L) {
                message.setTopN(this._topN);
            }
        }

        boolean isPaused() {
            return this._options != null && this._options.contains("pause");
        }
    }
}

