/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.FixedRecoveryPointFactory;
import com.crankuptheamps.client.JSONMessage;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.RecoveryPoint;
import com.crankuptheamps.client.RecoveryPointAdapter;
import com.crankuptheamps.client.RecoveryPointFactory;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.BookmarkRangeField;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryBookmarkStore
implements BookmarkStore {
    HashMap<Field, Subscription> _subs = new HashMap();
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 4000000;
    final CharsetEncoder _encoder = StandardCharsets.UTF_8.newEncoder();
    final CharsetDecoder _decoder = StandardCharsets.UTF_8.newDecoder();
    final Lock _lock = new ReentrantLock();
    protected RecoveryPointAdapter _adapter = null;
    protected RecoveryPointFactory _factory = null;
    Pool<Subscription> _pool;

    public MemoryBookmarkStore() {
        this(1);
    }

    public MemoryBookmarkStore(int targetNumberOfSubscriptions) {
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
    }

    public MemoryBookmarkStore(int targetNumberOfSubscriptions, RecoveryPointAdapter adapter) throws AMPSException {
        this(targetNumberOfSubscriptions, adapter, new FixedRecoveryPointFactory());
    }

    public MemoryBookmarkStore(int targetNumberOfSubscriptions, RecoveryPointAdapter adapter, RecoveryPointFactory factory) throws AMPSException {
        RecoveryPoint rp;
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        JSONMessage m = new JSONMessage(this._encoder, this._decoder);
        Iterator iterator = adapter.iterator();
        while (iterator.hasNext() && (rp = (RecoveryPoint)iterator.next()) != null) {
            Field subId = rp.getSubId();
            m.reset();
            m.setSubId(subId.buffer, subId.position, subId.length);
            BookmarkField bookmark = rp.getBookmark();
            if (bookmark.isRange()) {
                m.setBookmark(bookmark.buffer, bookmark.position, bookmark.length);
                this.log(m);
                continue;
            }
            for (BookmarkField bm : bookmark.parseBookmarkList()) {
                if (!bm.isTimestamp()) {
                    try {
                        m.setBookmark(bm.buffer, bm.position, bm.length);
                        this.isDiscarded(m);
                        if (this.log(m) <= 0L) continue;
                        this.discard(m);
                    }
                    catch (AMPSException aMPSException) {}
                    continue;
                }
                this.find(subId).setRecoveryTimestamp(bm.toString());
            }
        }
        this._adapter = adapter;
        this._factory = factory;
    }

    public void setRecoveryPointFactory(RecoveryPointFactory factory_) throws AMPSException {
        if (factory_ == null || this._adapter == null) {
            throw new CommandException("Factory and Adapter must not be null.");
        }
        this._factory = factory_;
    }

    @Override
    public long log(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        if (bookmark.equals(Subscription.EPOCH_FIELD)) {
            return 0L;
        }
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        try {
            long seqNo = sub.log(bookmark);
            message.setBookmarkSeqNo(seqNo);
            return seqNo;
        }
        catch (IOException e) {
            throw new StoreException("Failed to save range in RecoveryPointAdapter", e);
        }
    }

    @Override
    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        try {
            this.find(subId).discard(bookmarkSeqNo);
        }
        catch (IOException e) {
            throw new StoreException("Error discarding from bookmark store: " + e, e);
        }
    }

    @Override
    public void discard(Message message) throws AMPSException {
        long bookmark = message.getBookmarkSeqNo();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            BookmarkField bmField = message.getBookmarkRaw();
            if (bmField.equals(Subscription.EPOCH_FIELD) || bmField.isTimestamp() || bmField.isRange() || bmField.isBookmarkList()) {
                return;
            }
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        try {
            sub.discard(bookmark);
        }
        catch (IOException e) {
            throw new StoreException("Error discarding from bookmark store: " + e, e);
        }
    }

    @Override
    public Field getMostRecent(Field subId) throws AMPSException {
        return this.getMostRecent(subId, true);
    }

    @Override
    public Field getMostRecent(Field subId, boolean useList) throws AMPSException {
        return this.find(subId).getMostRecentList(useList).copy();
    }

    @Override
    public boolean isDiscarded(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        if (bookmark.equals(Subscription.EPOCH_FIELD)) {
            return true;
        }
        if (bookmark.isTimestamp() || bookmark.isBookmarkList()) {
            return false;
        }
        Field subId = message.getSubIdRaw();
        if (subId == null || subId.isNull()) {
            subId = message.getSubIdsRaw();
        }
        Subscription sub = this.find(subId);
        message.setSubscription(sub);
        return sub.isDiscarded(bookmark);
    }

    @Override
    @Deprecated
    public void persisted(Field subId, long bookmark) throws AMPSException {
        try {
            this.find(subId).setLastPersisted(bookmark);
        }
        catch (IOException e) {
            throw new StoreException("Error logging persisted to bookmark store: " + e, e);
        }
    }

    @Override
    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
        try {
            this.find(subId).setLastPersisted(bookmark);
        }
        catch (IOException e) {
            throw new StoreException("Error logging persisted to bookmark store: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription find(Field subId) {
        this._lock.lock();
        try {
            Subscription s = this._subs.get(subId);
            if (s == null) {
                s = this._pool.get();
                s.init(subId, this);
                s.setResizeHandler(this._resizeHandler, this);
                this._subs.put(subId.copy(), s);
            }
            Subscription subscription = s;
            return subscription;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void purge() throws AMPSException {
        this._lock.lock();
        try {
            for (Subscription sub : this._subs.values()) {
                sub.reset();
                this._pool.returnToPool(sub);
            }
            this._subs.clear();
            if (this._adapter != null) {
                this._adapter.purge();
            }
        }
        catch (Exception e) {
            throw new StoreException("An error occurred while purging recoverystate from recovery point adapter: " + e, e);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void purge(Field subId_) throws AMPSException {
        this._lock.lock();
        try {
            Subscription sub = this._subs.remove(subId_);
            if (sub == null) {
                return;
            }
            sub.reset();
            this._pool.returnToPool(sub);
            if (this._adapter != null) {
                this._adapter.purge(subId_);
            }
        }
        catch (Exception e) {
            throw new StoreException("An error occurred while purging recoverystate from recovery point adapter for subId '" + subId_.toString() + "': " + e, e);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOldestBookmarkSeq(Field subId) throws AMPSException {
        this._lock.lock();
        try {
            long retVal = 0L;
            long l = retVal = this.find(subId).getOldestBookmarkSeq();
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._resizeHandler = handler;
        for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
            pairs.getValue().setResizeHandler(handler, this);
        }
    }

    @Override
    public void setServerVersion(int version) {
        this._serverVersion = version;
    }

    public int getServerVersion() {
        return this._serverVersion;
    }

    @Override
    public void close() throws AMPSException {
        this._lock.lock();
        try {
            if (this._adapter != null) {
                this._adapter.close();
                this._adapter = null;
            }
        }
        catch (Exception e) {
            throw new StoreException("An error occurred while closing the underlying recovery point adapter: " + e, e);
        }
        finally {
            this._lock.unlock();
        }
    }

    protected void adapterUpdate(Field subId, BookmarkField bookmark) throws IOException {
        try {
            this._adapter.update(this._factory.createRecoveryPoint(subId, bookmark));
        }
        catch (Exception e) {
            throw new IOException("Exception in LoggedBookmarkStore updating the RecoveryPointAdapter", e);
        }
    }

    protected static class Subscription
    implements com.crankuptheamps.client.Subscription {
        Field _sub;
        BookmarkField _lastPersisted;
        protected volatile String _recoveryTimestamp = null;
        BookmarkRangeField _range = new BookmarkRangeField();
        static final Field EPOCH_FIELD = new Field("0");
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        HashMap<Long, Long> _publishers = new HashMap();
        final Lock _lock = new ReentrantLock();
        final CharsetEncoder _encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder _decoder = StandardCharsets.UTF_8.newDecoder();
        MemoryBookmarkStore _parent;

        public Subscription(Field subscriptionId) {
            this._sub = subscriptionId.copy();
            this._ring.setSubId(this._sub);
            this._lastPersisted = new BookmarkField();
            this._lastPersisted.copyFrom(EPOCH_FIELD);
        }

        public Subscription() {
            this._lastPersisted = new BookmarkField();
            this._lastPersisted.copyFrom(EPOCH_FIELD);
        }

        public void reset() {
            this._lock.lock();
            try {
                this._sub.reset();
                this._lastPersisted.copyFrom(EPOCH_FIELD);
                this._ring.reset();
                this._publishers.clear();
                this._range.reset();
            }
            finally {
                this._lock.unlock();
            }
        }

        public void init(Field subId, MemoryBookmarkStore parent) {
            this._lock.lock();
            try {
                this._sub = subId.copy();
                this._ring.setSubId(this._sub);
                this._parent = parent;
            }
            finally {
                this._lock.unlock();
            }
        }

        public String getRecoveryTimestamp() {
            return this._recoveryTimestamp;
        }

        protected final void setRecoveryTimestamp(String rts) {
            this._recoveryTimestamp = rts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long log(BookmarkField bookmark) throws IOException, CommandException {
            this._lock.lock();
            try {
                if (!bookmark.isRange()) {
                    if (!bookmark.isBookmarkList()) {
                        long l = this._log(bookmark);
                        return l;
                    }
                    long seq = 0L;
                    for (BookmarkField bm : bookmark.parseBookmarkList()) {
                        this.isDiscarded(bm);
                        seq = this._log(bm);
                        if (seq == 0L) continue;
                        this._ring.discard(seq);
                    }
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, bookmark);
                    }
                    long l = 0L;
                    return l;
                }
                this._range.copyFrom(bookmark);
                if (!this._range.isValid()) {
                    this._range.reset();
                    throw new CommandException("Invalid bookmark range specified");
                }
                long seq = 0L;
                if (this._range.isStartExclusive()) {
                    BookmarkField start = this._range.getStart();
                    if (!start.isBookmarkList()) {
                        this.isDiscarded(start);
                        seq = this._log(start);
                        if (seq != 0L) {
                            this._ring.discard(seq);
                        }
                    } else {
                        for (BookmarkField bm : start.parseBookmarkList()) {
                            this.isDiscarded(bm);
                            seq = this._log(bm);
                            if (seq == 0L) continue;
                            this._ring.discard(seq);
                        }
                        seq = 0L;
                    }
                }
                if (this._parent._adapter != null) {
                    this._parent.adapterUpdate(this._sub, this._range);
                }
                long l = seq;
                return l;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long _log(BookmarkField bm) throws IOException {
            long seq = 0L;
            if (!bm.isTimestamp()) {
                seq = this._ring.log(bm);
                while (seq == 0L) {
                    this._lock.unlock();
                    try {
                        this._ring.checkResize();
                    }
                    finally {
                        this._lock.lock();
                    }
                    seq = this._ring.log(bm);
                }
            } else {
                this.setLastPersisted(bm);
            }
            return seq;
        }

        @Override
        public void discard(long index) throws IOException {
            this._lock.lock();
            try {
                if (this._ring.discard(index)) {
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                    this._recoveryTimestamp = null;
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDiscarded(BookmarkField bookmark) {
            this._lock.lock();
            try {
                long publisher = bookmark.getPublisherId();
                long sequence = bookmark.getSequenceNumber();
                if (!this._publishers.containsKey(publisher) || Subscription.unsignedLongLess(this._publishers.get(publisher), sequence)) {
                    this._publishers.put(publisher, sequence);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public BookmarkRangeField getRange() {
            this._lock.lock();
            try {
                BookmarkRangeField bookmarkRangeField = this._range.copy();
                return bookmarkRangeField;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public Field getMostRecent() {
            this._lock.lock();
            try {
                BookmarkField bookmarkField = this._ring.getLastDiscarded().copy();
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        private static String convertUnsignedLongToString(long publisherId_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (publisherId_ < 0L) {
                return offset.add(BigInteger.valueOf(publisherId_)).toString();
            }
            return Long.toString(publisherId_);
        }

        private static boolean unsignedLongLess(long seqLeft_, long seqRight_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (seqLeft_ < 0L || seqRight_ < 0L) {
                BigInteger right;
                BigInteger left = offset.add(BigInteger.valueOf(seqLeft_));
                return left.compareTo(right = offset.add(BigInteger.valueOf(seqRight_))) < 0;
            }
            return seqLeft_ < seqRight_;
        }

        private static boolean unsignedLongLessEqual(long seqLeft_, long seqRight_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (seqLeft_ < 0L || seqRight_ < 0L) {
                BigInteger right;
                BigInteger left = offset.add(BigInteger.valueOf(seqLeft_));
                return left.compareTo(right = offset.add(BigInteger.valueOf(seqRight_))) <= 0;
            }
            return seqLeft_ <= seqRight_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Field getMostRecentList(boolean useList) {
            this._lock.lock();
            try {
                boolean rangeIsValid = this._range.isValid();
                BookmarkField lastDiscarded = this._ring.getLastDiscarded();
                boolean useLastDiscarded = lastDiscarded != null && !lastDiscarded.isNull();
                long lastDiscardedPub = 0L;
                long lastDiscardedSeq = 0L;
                boolean useLastPersisted = this._lastPersisted != null && this._lastPersisted.length > 1;
                long lastPersistedPub = 0L;
                long lastPersistedSeq = 0L;
                if (useLastPersisted) {
                    lastPersistedPub = this._lastPersisted.getPublisherId();
                    lastPersistedSeq = this._lastPersisted.getSequenceNumber();
                }
                if (useLastDiscarded) {
                    if (this._ring.isEmpty() && useLastPersisted && (!rangeIsValid || this._range.getEnd().equals(this._lastPersisted))) {
                        useLastDiscarded = false;
                    } else {
                        lastDiscardedPub = lastDiscarded.getPublisherId();
                        lastDiscardedSeq = lastDiscarded.getSequenceNumber();
                        if (useLastPersisted && lastPersistedPub == lastDiscardedPub) {
                            useLastPersisted = lastPersistedSeq < lastDiscardedSeq;
                            useLastDiscarded = !useLastPersisted;
                        }
                    }
                }
                StringBuilder recentStr = new StringBuilder();
                BookmarkField recentList = new BookmarkField();
                if (this._recoveryTimestamp != null) {
                    recentStr.append(this._recoveryTimestamp);
                }
                if (useLastDiscarded) {
                    if (recentStr.length() > 0) {
                        recentStr.append(',');
                    }
                    recentStr.append(lastDiscarded.getValue(this._decoder));
                }
                if (useList && (!useLastPersisted && !useLastDiscarded || this._lastPersisted != null && this._lastPersisted.equals(EPOCH_FIELD))) {
                    BookmarkField bookmarkField;
                    if (this._publishers.isEmpty() && !rangeIsValid) {
                        if (this._lastPersisted == null) {
                            this._lastPersisted = new BookmarkField();
                            this._lastPersisted.copyFrom(EPOCH_FIELD);
                        }
                        BookmarkField bookmarkField2 = this._lastPersisted;
                        return bookmarkField2;
                    }
                    if (useLastDiscarded && lastDiscarded.equals(EPOCH_FIELD)) {
                        int len = recentStr.length();
                        if (len == 1) {
                            recentStr.setLength(0);
                        } else if (len > 2) {
                            recentStr.setLength(len - 2);
                        }
                    }
                    for (Map.Entry<Long, Long> pairs : this._publishers.entrySet()) {
                        long pubId = pairs.getKey();
                        if (pubId == 0L || useLastDiscarded && pubId == lastDiscardedPub) continue;
                        long seq = pairs.getValue();
                        if (recentStr.length() > 0) {
                            recentStr.append(',');
                        }
                        recentStr.append(Subscription.convertUnsignedLongToString(pubId)).append('|').append(Subscription.convertUnsignedLongToString(seq)).append('|');
                    }
                    recentList.setValue(recentStr.toString(), this._encoder);
                    if (rangeIsValid) {
                        if (recentList.length > 1 && (this._range.isStartInclusive() || !recentList.equals(this._range.getStart()))) {
                            this._range.replaceStart(recentList, true);
                        }
                        bookmarkField = this._range;
                        return bookmarkField;
                    }
                    bookmarkField = recentList;
                    return bookmarkField;
                }
                if (useLastPersisted) {
                    if (recentStr.length() > 0) {
                        recentStr.append(',');
                    }
                    recentStr.append(this._lastPersisted.getValue(this._decoder));
                }
                recentList.setValue(recentStr.toString(), this._encoder);
                if (rangeIsValid) {
                    if (recentList.length > 1 && (this._range.isStartInclusive() || !recentList.equals(this._range.getStart()))) {
                        this._range.replaceStart(recentList, true);
                    }
                    BookmarkRangeField bookmarkRangeField = this._range;
                    return bookmarkRangeField;
                }
                BookmarkField bookmarkField = recentList;
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void setLastPersisted(long bookmark) throws IOException {
            this._lock.lock();
            try {
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(bookmark);
                if (entry == null) {
                    return;
                }
                if (this._lastPersisted != null) {
                    this._lastPersisted.reset();
                }
                this._lastPersisted = entry.getBookmark().copy();
                this._recoveryTimestamp = null;
                if (this._parent._adapter != null) {
                    this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLastPersisted(BookmarkField bookmark) throws IOException {
            this._lock.lock();
            try {
                if (bookmark == null || bookmark.isNull() || bookmark.equals(this._lastPersisted) || bookmark.isRange()) {
                    return;
                }
                if (bookmark.isTimestamp()) {
                    if (this._lastPersisted != null) {
                        this._lastPersisted.reset();
                    }
                    this._lastPersisted = bookmark.copy();
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                    return;
                }
                long publisherId = bookmark.getPublisherId();
                if (this._lastPersisted != null && publisherId == this._lastPersisted.getPublisherId() && Subscription.unsignedLongLessEqual(bookmark.getSequenceNumber(), this._lastPersisted.getSequenceNumber())) {
                    return;
                }
                BookmarkField lastPersisted = this._lastPersisted;
                this._lastPersisted = bookmark.copy();
                this._recoveryTimestamp = null;
                if (this._parent._adapter != null) {
                    this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                }
                if (lastPersisted != null) {
                    lastPersisted.reset();
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public long getOldestBookmarkSeq() {
            this._lock.lock();
            try {
                long l = this._ring.getStartIndex();
                return l;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }
    }
}

