/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.fields.AckTypeField;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.CommandField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.OptionsField;
import com.crankuptheamps.client.fields.StatusField;
import com.crankuptheamps.client.fields.StringField;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class JSONMessage
extends Message {
    private static final Charset LATIN1 = StandardCharsets.ISO_8859_1;
    private static byte[] TG_COMMAND = null;
    private static byte[] TG_COMMANDID = null;
    private static byte[] TG_CORRELATION_ID = null;
    private static byte[] TG_CLIENTNAME = null;
    private static byte[] TG_USERID = null;
    private static byte[] TG_TIMESTAMP = null;
    private static byte[] TG_TOPIC = null;
    private static byte[] TG_FILTER = null;
    private static byte[] TG_ORDERBY = null;
    private static byte[] TG_ACKTYPE = null;
    private static byte[] TG_SUBID = null;
    private static byte[] TG_VERSION = null;
    private static byte[] TG_EXPIRATION = null;
    private static byte[] TG_STATUS = null;
    private static byte[] TG_QUERYID = null;
    private static byte[] TG_SENDOOF = null;
    private static byte[] TG_BATCHSIZE = null;
    private static byte[] TG_TOPN = null;
    private static byte[] TG_SOWKEYS = null;
    private static byte[] TG_SEQUENCE = null;
    private static byte[] TG_BOOKMARK = null;
    private static byte[] TG_PASSWORD = null;
    private static byte[] TG_MESSAGETYPE = null;
    private static byte[] TG_RECORDS_INSERTED = null;
    private static byte[] TG_RECORDS_UPDATED = null;
    private static byte[] TG_RECORDS_DELETED = null;
    private static byte[] TG_RECORDS_RETURNED = null;
    private static byte[] TG_TOPIC_MATCHES = null;
    private static byte[] TG_MATCHES = null;
    private static byte[] TG_LENGTH = null;
    private static byte[] TG_SOW_KEY = null;
    private static byte[] TG_GROUP_SEQ_NO = null;
    private static byte[] TG_SUB_IDS = null;
    private static byte[] TG_REASON = null;
    private static byte[] TG_OPTIONS = null;
    private static byte[] COMMA = null;
    private static byte[] QUOTE = null;
    private static byte[] QUOTE_COLON = null;
    private static byte[] OPEN_BRACE = null;
    private static byte[] CLOSE_BRACE = null;
    private static final Set<Class> QUOTED_CLASSES;

    public JSONMessage(CharsetEncoder encoder, CharsetDecoder decoder) {
        super(encoder, decoder);
    }

    private final boolean needsEscape(byte[] fieldName) {
        switch ((char)fieldName[0]) {
            case 's': {
                switch (fieldName.length) {
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 'c': 
            case 'f': 
            case 'p': 
            case 't': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    private final void escapeField(ByteBuffer b, Field field) {
        for (int i = 0; i < field.length; ++i) {
            if (field.byteAt(i) == 34 || field.byteAt(i) == 92) {
                b.put((byte)92);
                b.put(field.byteAt(i));
                continue;
            }
            b.put(field.byteAt(i));
        }
    }

    private final int serializeMessageProperty(ByteBuffer b, byte[] tag, Field field, int count) {
        if (field.buffer == null) {
            return 0;
        }
        if (count > 0) {
            b.put(COMMA);
        }
        b.put(QUOTE);
        b.put(tag);
        b.put(QUOTE_COLON);
        boolean quoted = QUOTED_CLASSES.contains(field.getClass());
        if (quoted) {
            b.put(QUOTE);
        }
        if (this.needsEscape(tag)) {
            this.escapeField(b, field);
        } else {
            b.put(field.buffer, field.position, field.length);
        }
        if (quoted) {
            b.put(QUOTE);
        }
        return 1;
    }

    @Override
    public Message.SerializationResult serialize(ByteBuffer b) {
        try {
            b.put(OPEN_BRACE);
            int count = 0;
            count += this.serializeMessageProperty(b, TG_COMMAND, this._Command, count);
            count += this.serializeMessageProperty(b, TG_COMMANDID, this._CommandId, count);
            count += this.serializeMessageProperty(b, TG_CORRELATION_ID, this._CorrelationId, count);
            count += this.serializeMessageProperty(b, TG_CLIENTNAME, this._ClientName, count);
            count += this.serializeMessageProperty(b, TG_USERID, this._UserId, count);
            count += this.serializeMessageProperty(b, TG_PASSWORD, this._Password, count);
            count += this.serializeMessageProperty(b, TG_TOPIC, this._Topic, count);
            count += this.serializeMessageProperty(b, TG_FILTER, this._Filter, count);
            count += this.serializeMessageProperty(b, TG_ORDERBY, this._OrderBy, count);
            count += this.serializeMessageProperty(b, TG_ACKTYPE, this._AckType, count);
            count += this.serializeMessageProperty(b, TG_OPTIONS, this._Options, count);
            count += this.serializeMessageProperty(b, TG_SUBID, this._SubId, count);
            count += this.serializeMessageProperty(b, TG_VERSION, this._Version, count);
            count += this.serializeMessageProperty(b, TG_EXPIRATION, this._Expiration, count);
            count += this.serializeMessageProperty(b, TG_STATUS, this._Status, count);
            count += this.serializeMessageProperty(b, TG_QUERYID, this._QueryId, count);
            count += this.serializeMessageProperty(b, TG_BATCHSIZE, this._BatchSize, count);
            count += this.serializeMessageProperty(b, TG_BOOKMARK, this._Bookmark, count);
            count += this.serializeMessageProperty(b, TG_SEQUENCE, this._Sequence, count);
            count += this.serializeMessageProperty(b, TG_TOPN, this._TopN, count);
            count += this.serializeMessageProperty(b, TG_SOWKEYS, this._SowKeys, count);
            count += this.serializeMessageProperty(b, TG_SOW_KEY, this._SowKey, count);
            this.serializeMessageProperty(b, TG_MESSAGETYPE, this._MessageType, count);
            b.put(CLOSE_BRACE);
            if (this._Data.buffer != null) {
                b.put(this._Data.buffer, this._Data.position, this._Data.length);
            }
        }
        catch (BufferOverflowException e) {
            return Message.SerializationResult.BufferTooSmall;
        }
        return Message.SerializationResult.OK;
    }

    @Override
    public Message copy() {
        JSONMessage m = new JSONMessage(this.encoder, this.decoder);
        this._copyTo(m);
        return m;
    }

    static {
        TG_COMMAND = "c".getBytes(LATIN1);
        TG_COMMANDID = "cid".getBytes(LATIN1);
        TG_CORRELATION_ID = "x".getBytes(LATIN1);
        TG_CLIENTNAME = "client_name".getBytes(LATIN1);
        TG_USERID = "user_id".getBytes(LATIN1);
        TG_TOPIC = "t".getBytes(LATIN1);
        TG_FILTER = "filter".getBytes(LATIN1);
        TG_ORDERBY = "orderby".getBytes(LATIN1);
        TG_ACKTYPE = "a".getBytes(LATIN1);
        TG_SUBID = "sub_id".getBytes(LATIN1);
        TG_VERSION = "v".getBytes(LATIN1);
        TG_EXPIRATION = "e".getBytes(LATIN1);
        TG_STATUS = "status".getBytes(LATIN1);
        TG_QUERYID = "query_id".getBytes(LATIN1);
        TG_BATCHSIZE = "batch_size".getBytes(LATIN1);
        TG_TOPN = "top_n".getBytes(LATIN1);
        TG_SOWKEYS = "sow_keys".getBytes(LATIN1);
        TG_SEQUENCE = "s".getBytes(LATIN1);
        TG_BOOKMARK = "bookmark".getBytes(LATIN1);
        TG_PASSWORD = "pw".getBytes(LATIN1);
        TG_RECORDS_INSERTED = "records_inserted".getBytes(LATIN1);
        TG_RECORDS_UPDATED = "records_updated".getBytes(LATIN1);
        TG_RECORDS_DELETED = "records_deleted".getBytes(LATIN1);
        TG_RECORDS_RETURNED = "records_returned".getBytes(LATIN1);
        TG_TOPIC_MATCHES = "topic_matches".getBytes(LATIN1);
        TG_MATCHES = "matches".getBytes(LATIN1);
        TG_LENGTH = "l".getBytes(LATIN1);
        TG_SOW_KEY = "k".getBytes(LATIN1);
        TG_GROUP_SEQ_NO = "group_seq_num".getBytes(LATIN1);
        TG_SUB_IDS = "sub_ids".getBytes(LATIN1);
        TG_REASON = "reason".getBytes(LATIN1);
        TG_OPTIONS = "opts".getBytes(LATIN1);
        TG_MESSAGETYPE = "mt".getBytes(LATIN1);
        COMMA = ",".getBytes(LATIN1);
        QUOTE = "\"".getBytes(LATIN1);
        QUOTE_COLON = "\":".getBytes(LATIN1);
        OPEN_BRACE = "{".getBytes(LATIN1);
        CLOSE_BRACE = "}".getBytes(LATIN1);
        QUOTED_CLASSES = new HashSet<Class>();
        QUOTED_CLASSES.add(StringField.class);
        QUOTED_CLASSES.add(CommandField.class);
        QUOTED_CLASSES.add(AckTypeField.class);
        QUOTED_CLASSES.add(BookmarkField.class);
        QUOTED_CLASSES.add(StatusField.class);
        QUOTED_CLASSES.add(OptionsField.class);
    }
}

