/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.fields.Field;

public class CompositeMessageBuilder {
    private static int DEFAULT_INITIAL_CAPACITY = 16384;
    private static int HEADER_LENGTH = 4;
    public byte[] _bytes = null;
    public int _position = 0;

    public CompositeMessageBuilder() {
        this._bytes = new byte[DEFAULT_INITIAL_CAPACITY];
        this._position = 0;
    }

    public CompositeMessageBuilder(int initialCapacity_) {
        this._bytes = new byte[initialCapacity_];
        this._position = 0;
    }

    public CompositeMessageBuilder clear() {
        this._position = 0;
        return this;
    }

    public CompositeMessageBuilder append(byte[] data_, int offset_, int length_) {
        if (this._bytes.length < this._position + length_ + HEADER_LENGTH) {
            this._resizeToAtLeast(this._position + length_ + HEADER_LENGTH);
        }
        this._writeHeader(length_);
        this._write(data_, offset_, length_);
        return this;
    }

    public CompositeMessageBuilder append(String data_) {
        byte[] buf = data_.getBytes();
        return this.append(buf, 0, buf.length);
    }

    public void setField(Field field_) {
        field_.buffer = this._bytes;
        field_.length = this._position;
        field_.position = 0;
    }

    private void _write(byte[] data_, int offset_, int length_) {
        if (length_ > 0) {
            System.arraycopy(data_, offset_, this._bytes, this._position, length_);
            this._position += length_;
        }
    }

    private void _writeHeader(int length_) {
        this._bytes[this._position++] = (byte)((length_ & 0xFF000000) >> 24);
        this._bytes[this._position++] = (byte)((length_ & 0xFF0000) >> 16);
        this._bytes[this._position++] = (byte)((length_ & 0xFF00) >> 8);
        this._bytes[this._position++] = (byte)(length_ & 0xFF);
    }

    private void _resizeToAtLeast(int newSize_) {
        byte[] newData = new byte[(int)((double)newSize_ * 1.5)];
        System.arraycopy(this._bytes, 0, newData, 0, this._position);
        this._bytes = newData;
    }
}

