/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class BookmarkRingBuffer {
    static final int INITIAL_ENTRY_COUNT = 1000;
    public static final int UNSET_INDEX = -1;
    Entry[] _entries = new Entry[1000];
    int _start = 1;
    int _end = 1;
    long _index = 1L;
    long _indexOfStart = 0L;
    BookmarkField _lastDiscarded = new BookmarkField();
    boolean _empty = true;
    BookmarkStoreResizeHandler _resizeHandler;
    BookmarkStore _store;
    Field _subId;
    volatile boolean _canResize = false;

    public BookmarkRingBuffer() {
        this._lastDiscarded.set("0".getBytes(Charset.defaultCharset()));
        for (int i = 0; i < this._entries.length; ++i) {
            this._entries[i] = new Entry();
        }
    }

    public void reset() {
        for (int i = 0; i < this._entries.length; ++i) {
            this._entries[i].setActive(false).setIndex(0L).getBookmark().reset();
        }
        this._start = 1;
        this._end = 1;
        this._index = 1L;
        this._indexOfStart = 0L;
        this._lastDiscarded.set("0".getBytes(Charset.defaultCharset()));
        this._empty = true;
        this._resizeHandler = null;
        this._store = null;
        this._subId = null;
        this._canResize = false;
    }

    public int capacity() {
        return this._entries.length;
    }

    public Entry getByIndex(long index) {
        int offsetFromStart = 0;
        if (index < this._indexOfStart + (long)this._start || index >= this._index) {
            return null;
        }
        offsetFromStart = (int)(index - this._indexOfStart) % this._entries.length;
        return this._entries[offsetFromStart];
    }

    public BookmarkField getLastDiscarded() {
        return this._lastDiscarded;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public long getStartIndex() {
        if (this._empty) {
            return -1L;
        }
        return this._indexOfStart + (long)this._start;
    }

    public long getEndIndex() {
        if (this._empty) {
            return -1L;
        }
        return this._index;
    }

    public long log(BookmarkField bookmark) {
        if (this._end == this._start && !this._empty) {
            if (!this._canResize) {
                return 0L;
            }
            this.resize();
        }
        this._empty = false;
        int writeIndex = this._end++;
        this._entries[writeIndex].setBookmark(bookmark).setActive(true).setIndex(this._index);
        if (this._end == this._entries.length) {
            this._end = 0;
        }
        return this._index++;
    }

    public boolean discard(long index) {
        boolean retVal = false;
        if (index < this._indexOfStart + (long)this._start || index >= this._index) {
            return retVal;
        }
        int offsetFromStart = (int)(index - this._indexOfStart);
        int indexInArray = offsetFromStart % this._entries.length;
        this._entries[indexInArray].setActive(false);
        if (this._start == indexInArray) {
            Entry lastDiscardedEntry = null;
            while (!(this._entries[this._start].isActive() || this._entries[this._start].getBookmark().isNull() || this._start == this._end && this._empty)) {
                if (lastDiscardedEntry != null) {
                    lastDiscardedEntry.getBookmark().reset();
                }
                lastDiscardedEntry = this._entries[this._start];
                if (++this._start == this._entries.length) {
                    this._start = 0;
                    this._indexOfStart += (long)this._entries.length;
                }
                this._empty = this._start == this._end;
            }
            if (lastDiscardedEntry != null) {
                BookmarkField bookmark = lastDiscardedEntry.getBookmark();
                if (bookmark != null && !bookmark.isNull()) {
                    this._lastDiscarded.copyFrom(bookmark);
                    bookmark.reset();
                }
                retVal = true;
            }
        }
        return retVal;
    }

    public Entry find(BookmarkField field) {
        if (this._empty) {
            return null;
        }
        long index = this._indexOfStart + (long)this._start;
        int i = this._start;
        do {
            if (!this._entries[i].getBookmark().isNull() && this._entries[i].getBookmark().equals(field)) {
                return this._entries[i].setIndex(index);
            }
            ++index;
        } while ((i = (i + 1) % this._entries.length) != this._end);
        return null;
    }

    @Deprecated
    public void persisted(BookmarkField bookmark) {
    }

    @Deprecated
    public void persisted(long bookmark) {
    }

    public void checkResize() {
        int oldLength = this._entries.length;
        this._canResize = this._resizeHandler == null || this._resizeHandler.invoke(this._store, this._subId, (int)((double)oldLength * 1.5));
    }

    private void resize() {
        this._canResize = false;
        int oldLength = this._entries.length;
        Entry[] newEntries = new Entry[(int)((double)oldLength * 1.5)];
        int start = this._start;
        System.arraycopy(this._entries, start, newEntries, 0, oldLength - start);
        if (start > 0) {
            System.arraycopy(this._entries, 0, newEntries, oldLength - start, start);
        }
        this._indexOfStart += (long)this._start;
        this._start = 0;
        this._end = oldLength;
        for (int i = oldLength; i < newEntries.length; ++i) {
            newEntries[i] = new Entry();
        }
        this._entries = newEntries;
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
        this._resizeHandler = handler;
        this._store = store;
    }

    public void setSubId(Field sub) {
        this._subId = sub.copy();
    }

    public void getRecoveryEntries(ArrayList<Entry> entryList_) {
        for (int idx = this._start; idx != this._end; idx %= this._entries.length) {
            entryList_.add(this._entries[idx]);
            ++idx;
        }
    }

    @Deprecated
    public long setRecovery() {
        return (long)this._start + this._indexOfStart;
    }

    @Deprecated
    public ArrayList<Entry> getRecoveryEntries() {
        return null;
    }

    @Deprecated
    public long relog(long oldIndex, BookmarkField bookmark) {
        return oldIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300 + (int)(this.getEndIndex() - this.getStartIndex()) * 100);
        sb.append(String.format("_entries.length = %d%n_start = %d%n_end = %d%n_index = %s%n_lastDiscarded = %s%n_subId = %s%n_canResize = %s%n_resizeHandler = %s%n_store = %s%n%nEntries:%n%n", this._entries.length, this._start, this._end, this._index, this._lastDiscarded, this._subId, this._canResize, this._resizeHandler, this._store));
        for (int idx = this._start; idx != this._end; idx %= this._entries.length) {
            sb.append(String.format("%5d: %s%n", idx, this._entries[idx]));
            ++idx;
        }
        return sb.toString();
    }

    public static class Entry {
        BookmarkField _bookmark = new BookmarkField();
        long _index = 0L;
        boolean _active = false;

        public Entry setBookmark(Field f) {
            this._bookmark.copyFrom(f);
            return this;
        }

        public BookmarkField getBookmark() {
            return this._bookmark;
        }

        public Entry setIndex(long index) {
            this._index = index;
            return this;
        }

        public long getIndex() {
            return this._index;
        }

        public boolean isActive() {
            return this._active;
        }

        public Entry setActive(boolean active) {
            this._active = active;
            return this;
        }

        @Deprecated
        public boolean isPersisted() {
            return true;
        }

        @Deprecated
        public Entry setPersisted(boolean persisted) {
            return this;
        }

        public String toString() {
            return "[ " + this._bookmark + ", active=" + this._active + ", index=" + this._index + " ]";
        }
    }
}

