/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.views;

import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.deps.com.google.gson.JsonParseException;
import com.couchbase.mock.views.DesignParseException;
import com.couchbase.mock.views.View;
import java.util.ArrayList;
import java.util.Map;
import javax.script.ScriptException;

public class DesignDocument {
    private final String body;
    private String id;
    private final ArrayList<View> views;

    private DesignDocument(String body) {
        this.body = body;
        this.views = new ArrayList();
    }

    public static DesignDocument create(String body, String name) throws DesignParseException {
        DesignDocument doc = new DesignDocument(body);
        doc.id = "_design/" + name;
        doc.load();
        return doc;
    }

    private void load() throws DesignParseException {
        try {
            JsonObject obj = JsonUtils.GSON.fromJson(this.body, JsonObject.class);
            if (obj.has("_id")) {
                this.id = obj.get("_id").getAsString();
            }
            if (this.id == null) {
                throw new DesignParseException("No _id specified and no implicit path provided");
            }
            JsonObject viewsJson = obj.getAsJsonObject("views");
            if (viewsJson == null) {
                throw new DesignParseException("Missing `views`");
            }
            for (Map.Entry<String, JsonElement> entry : viewsJson.entrySet()) {
                JsonElement curElem = entry.getValue();
                if (!curElem.isJsonObject()) {
                    throw new DesignParseException("View contents must be a JSON dictionary");
                }
                JsonObject view = curElem.getAsJsonObject();
                if (!view.has("map")) {
                    throw new DesignParseException("Missing `map` function");
                }
                String mapSrc = view.get("map").getAsString();
                String reduceSrc = null;
                if (view.has("reduce")) {
                    reduceSrc = view.get("reduce").getAsString();
                }
                this.views.add(new View(entry.getKey(), mapSrc, reduceSrc));
            }
        }
        catch (ScriptException ex) {
            throw new DesignParseException(ex);
        }
        catch (JsonParseException ex) {
            throw new DesignParseException(ex);
        }
    }

    public String getBody() {
        return this.body;
    }

    public String getId() {
        return this.id;
    }

    public ArrayList<View> getViews() {
        return this.views;
    }
}

