/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.subdoc;

import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.subdoc.Component;
import com.couchbase.mock.subdoc.PathMismatchException;
import com.couchbase.mock.subdoc.PathParseException;
import com.couchbase.mock.subdoc.PathTooDeepException;
import java.util.ArrayList;
import java.util.List;

public class Path {
    final List<Component> components = new ArrayList<Component>();
    public static final Component ROOT = new Component();
    public static final int MAX_DEPTH = 32;

    private StringBuilder addComponent(StringBuilder sb, boolean isIndex) throws PathParseException, PathTooDeepException {
        if (this.components.size() == 31) {
            throw new PathTooDeepException();
        }
        this.components.add(new Component(sb.toString(), isIndex));
        return new StringBuilder();
    }

    private boolean prevWasIndex() {
        return !this.components.isEmpty() && this.components.get(this.components.size() - 1).isIndex();
    }

    public Path(String input) throws PathParseException, PathTooDeepException {
        boolean wantIndex = false;
        boolean inEscape = false;
        int numEscaped = 0;
        StringBuilder sb = new StringBuilder();
        for (char s : input.toCharArray()) {
            if (s == '`') {
                if (inEscape) {
                    inEscape = false;
                    if (numEscaped != 0) continue;
                    sb.append('`');
                    continue;
                }
                inEscape = true;
                numEscaped = 0;
                continue;
            }
            if (inEscape) {
                ++numEscaped;
                sb.append(s);
                continue;
            }
            if (s == '[') {
                if (wantIndex) {
                    throw new PathParseException("Found nested brackets!");
                }
                if (!sb.toString().isEmpty()) {
                    sb = this.addComponent(sb, false);
                }
                wantIndex = true;
                continue;
            }
            if (s == ']') {
                if (!wantIndex) {
                    throw new PathParseException("Found ] without opening [");
                }
                sb = this.addComponent(sb, true);
                wantIndex = false;
                continue;
            }
            if (s == '.') {
                if (this.prevWasIndex()) continue;
                sb = this.addComponent(sb, false);
                wantIndex = false;
                continue;
            }
            sb.append(s);
        }
        if (wantIndex) {
            throw new PathParseException("Found unclosed [");
        }
        String lastComp = sb.toString();
        if (lastComp.isEmpty()) {
            if (!this.components.isEmpty() && !this.prevWasIndex()) {
                throw new PathParseException("Found empty non-root component!");
            }
        } else {
            this.components.add(new Component(lastComp, false));
        }
    }

    public Component get(int ix) {
        return this.components.get(ix);
    }

    public Component getLast() {
        if (this.components.isEmpty()) {
            return ROOT;
        }
        return this.components.get(this.components.size() - 1);
    }

    public int size() {
        return this.components.size();
    }

    public void validateComponentType(int ix, JsonElement parent) throws PathMismatchException, PathParseException {
        Component comp = this.components.get(ix);
        if (parent.isJsonPrimitive() || parent.isJsonNull()) {
            throw new PathMismatchException();
        }
        if (comp.isIndex()) {
            if (!parent.isJsonArray()) {
                throw new PathParseException("Object operation cannot have an array index as its last component");
            }
        } else if (!parent.isJsonObject()) {
            throw new PathMismatchException();
        }
    }
}

