/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.security.sasl;

import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class ShaSaslServer
implements SaslServer {
    private static final byte[] CLIENT_KEY = "Client Key".getBytes();
    private static final byte[] SERVER_KEY = "Server Key".getBytes();
    private final String name;
    private final String hmacAlgorithm;
    private final CallbackHandler callbacks;
    private final MessageDigest digest;
    private String username;
    private String clientNonce;
    private String serverNonce;
    private byte[] salt;
    private byte[] saltedPassword;
    private int iterationCount;
    private String clientFirstMessage;
    private String clientFirstMessageBare;
    private String clientFinalMessageNoProof;
    private String serverFirstMessage;

    public ShaSaslServer(CallbackHandler cbh, int sha) throws NoSuchAlgorithmException {
        this.callbacks = cbh;
        switch (sha) {
            case 512: {
                this.digest = MessageDigest.getInstance("SHA-512");
                this.name = "SCRAM-SHA512";
                this.hmacAlgorithm = "HmacSHA512";
                break;
            }
            case 256: {
                this.digest = MessageDigest.getInstance("SHA-256");
                this.name = "SCRAM-SHA256";
                this.hmacAlgorithm = "HmacSHA256";
                break;
            }
            case 1: {
                this.digest = MessageDigest.getInstance("SHA-1");
                this.name = "SCRAM-SHA1";
                this.hmacAlgorithm = "HmacSHA1";
                break;
            }
            default: {
                throw new RuntimeException("Invalid SHA version specified");
            }
        }
        byte[] randomNonce = new byte[21];
        SecureRandom random = new SecureRandom();
        random.nextBytes(randomNonce);
        this.serverNonce = new String(Base64.getEncoder().encode(randomNonce));
        this.iterationCount = 4096;
    }

    private static void xor(byte[] result, byte[] other) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(result[i] ^ other[i]);
        }
    }

    private static void decodeAttributes(HashMap<String, String> attributes, String string) {
        String[] tokens;
        for (String token : tokens = string.split(",")) {
            int idx = token.indexOf(61);
            if (idx != 1) {
                throw new IllegalArgumentException("the input string is not according to the spec");
            }
            String key = token.substring(0, 1);
            if (attributes.containsKey(key)) {
                throw new IllegalArgumentException("The key " + key + " is specified multiple times");
            }
            attributes.put(key, token.substring(2));
        }
    }

    @Override
    public String getMechanismName() {
        return this.name;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.clientFirstMessage == null) {
            return this.evaluateClientFirstMessage(response);
        }
        if (this.clientFinalMessageNoProof == null) {
            return this.evaluateClientFinalMessage(response);
        }
        throw new SaslException("Can't evaluate challenge on a session which is complete");
    }

    private byte[] evaluateClientFinalMessage(byte[] response) {
        String clientFinalMessage = new String(response);
        HashMap<String, String> attributes = new HashMap<String, String>();
        ShaSaslServer.decodeAttributes(attributes, clientFinalMessage);
        if (!attributes.containsKey("p")) {
            throw new IllegalArgumentException("client-final-message does not contain client proof");
        }
        int idx = clientFinalMessage.indexOf(",p=");
        this.clientFinalMessageNoProof = clientFinalMessage.substring(0, idx);
        byte[] serverSignature = this.getServerSignature();
        StringWriter writer = new StringWriter();
        writer.append("v=");
        writer.append(new String(Base64.getEncoder().encode(serverSignature)));
        String myClientProof = new String(Base64.getEncoder().encode(this.getClientProof()));
        if (!myClientProof.equals(attributes.get("p"))) {
            writer.append(",e=failed");
        }
        return writer.toString().getBytes();
    }

    private byte[] evaluateClientFirstMessage(byte[] response) throws SaslException {
        this.clientFirstMessage = new String(response);
        if (!this.clientFirstMessage.startsWith("n,")) {
            throw new SaslException("Invalid gs2 header");
        }
        int idx = this.clientFirstMessage.indexOf(44, 2);
        if (idx == -1) {
            throw new SaslException("Invalid gs2 header");
        }
        this.clientFirstMessageBare = this.clientFirstMessage.substring(idx + 1);
        HashMap<String, String> attributes = new HashMap<String, String>();
        ShaSaslServer.decodeAttributes(attributes, this.clientFirstMessageBare);
        block4: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            switch (entry.getKey().charAt(0)) {
                case 'n': {
                    this.username = entry.getValue();
                    continue block4;
                }
                case 'r': {
                    this.clientNonce = entry.getValue();
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid key supplied in the clientFirstMessageBare");
        }
        if (this.username.isEmpty() || this.clientNonce.isEmpty()) {
            throw new IllegalArgumentException("username and client nonce is mandatory in clientFirstMessageBare");
        }
        this.salt = Base64.getDecoder().decode("QSXCR+Q6sek8bf92");
        this.generateSaltedPassword();
        String nonce = this.clientNonce + this.serverNonce;
        StringBuilder writer = new StringBuilder();
        writer.append("r=");
        writer.append(nonce);
        writer.append(",s=");
        writer.append(new String(Base64.getEncoder().encode(this.salt)));
        writer.append(",i=");
        writer.append(Integer.toString(this.iterationCount));
        this.serverFirstMessage = writer.toString();
        return this.serverFirstMessage.getBytes();
    }

    @Override
    public boolean isComplete() {
        return this.clientFinalMessageNoProof != null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    private byte[] hmac(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance(this.hmacAlgorithm);
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException e) {
            if (key.length == 0) {
                throw new UnsupportedOperationException("This JVM does not support empty HMAC keys (empty passwords). Please set a bucket password or upgrade your JVM.");
            }
            throw new RuntimeException("Failed to generate HMAC hash for password", e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private byte[] pbkdf2(String password, byte[] salt, int iterations) {
        try {
            Mac mac = Mac.getInstance(this.hmacAlgorithm);
            SecretKey key = password == null || password.isEmpty() ? new EmptySecretKey(this.hmacAlgorithm) : new SecretKeySpec(password.getBytes(), this.hmacAlgorithm);
            mac.init(key);
            mac.update(salt);
            mac.update("\u0000\u0000\u0000\u0001".getBytes());
            byte[] un = mac.doFinal();
            mac.update(un);
            byte[] uprev = mac.doFinal();
            ShaSaslServer.xor(un, uprev);
            for (int i = 2; i < iterations; ++i) {
                mac.update(uprev);
                uprev = mac.doFinal();
                ShaSaslServer.xor(un, uprev);
            }
            return un;
        }
        catch (InvalidKeyException e) {
            if (password == null || password.isEmpty()) {
                throw new UnsupportedOperationException("This JVM does not support empty HMAC keys (empty passwords). Please set a bucket password or upgrade your JVM.");
            }
            throw new RuntimeException("Failed to generate HMAC hash for password", e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void generateSaltedPassword() throws SaslException {
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            this.callbacks.handle(new Callback[]{passwordCallback});
        }
        catch (IOException e) {
            throw new SaslException("Missing callback fetch password", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Missing callback fetch password", e);
        }
        char[] pw = passwordCallback.getPassword();
        if (pw == null) {
            throw new SaslException("Password can't be null");
        }
        String password = new String(pw);
        this.saltedPassword = this.pbkdf2(password, this.salt, this.iterationCount);
        passwordCallback.clearPassword();
    }

    private byte[] getServerSignature() {
        byte[] serverKey = this.hmac(this.saltedPassword, SERVER_KEY);
        return this.hmac(serverKey, this.getAuthMessage().getBytes());
    }

    private byte[] getClientProof() {
        byte[] clientKey = this.hmac(this.saltedPassword, CLIENT_KEY);
        byte[] storedKey = this.digest.digest(clientKey);
        byte[] clientSignature = this.hmac(storedKey, this.getAuthMessage().getBytes());
        ShaSaslServer.xor(clientKey, clientSignature);
        return clientKey;
    }

    private String getAuthMessage() {
        if (this.clientFirstMessageBare == null) {
            throw new RuntimeException("can't call getAuthMessage without clientFirstMessageBare is set");
        }
        if (this.serverFirstMessage == null) {
            throw new RuntimeException("can't call getAuthMessage without serverFirstMessage is set");
        }
        if (this.clientFinalMessageNoProof == null) {
            throw new RuntimeException("can't call getAuthMessage without clientFinalMessageNoProof is set");
        }
        return this.clientFirstMessageBare + "," + this.serverFirstMessage + "," + this.clientFinalMessageNoProof;
    }

    @Override
    public String getAuthorizationID() {
        return null;
    }

    private static class EmptySecretKey
    implements SecretKey {
        private final String algorithm;

        public EmptySecretKey(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }
    }
}

