/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.errormap;

import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.errormap.RetrySpec;
import java.util.ArrayList;
import java.util.List;

public abstract class Verifier {
    public static final String STRATEGY_EXPONENTIAL = "exponential";
    public static final String STRATEGY_LINEAR = "linear";
    public static final String STRATEGY_CONSTANT = "constant";
    public static final long DEFAULT_FUZZ_MS = 10L;
    protected MemcachedServer.CommandLogEntry firstEntry = null;
    protected long fuzzMillis = 10L;

    protected void verify(List<MemcachedServer.CommandLogEntry> entries, RetrySpec spec) throws VerificationException {
        if (entries.size() < 2) {
            throw new VerificationException("No commands executed: Log has " + entries.size());
        }
        this.firstEntry = entries.get(0);
        entries.remove(0);
        long endTime = entries.get(entries.size() - 1).getMsTimestamp();
        long duration = endTime - this.firstEntry.getMsTimestamp();
        if (duration > (long)spec.getMaxDuration() + this.fuzzMillis) {
            throw new DurationExceededException(spec.getMaxDuration(), duration);
        }
        if (entries.get(0).getMsTimestamp() - this.firstEntry.getMsTimestamp() < (long)(spec.getAfter() - 1)) {
            throw new FirstRetryTooSoonException();
        }
        this.verifyImpl(entries, spec);
    }

    protected abstract void verifyImpl(List<MemcachedServer.CommandLogEntry> var1, RetrySpec var2) throws VerificationException;

    public static void verifyThrow(List<MemcachedServer.CommandLogEntry> allEntries, RetrySpec spec, int opcode) throws VerificationException {
        Verifier.verifyThrow(allEntries, spec, opcode, 0L);
    }

    public static void verifyThrow(List<MemcachedServer.CommandLogEntry> allEntries, RetrySpec spec, int opcode, long fuzzMillis) throws VerificationException {
        Verifier verifier;
        ArrayList<MemcachedServer.CommandLogEntry> entries = new ArrayList<MemcachedServer.CommandLogEntry>();
        for (MemcachedServer.CommandLogEntry entry : allEntries) {
            if (entry.getOpcode() != opcode) continue;
            entries.add(entry);
        }
        if (spec.getStrategy().equals(STRATEGY_CONSTANT)) {
            verifier = new ConstantVerifier();
        } else if (spec.getStrategy().equals(STRATEGY_LINEAR)) {
            verifier = new LinearVerifier();
        } else if (spec.getStrategy().equals(STRATEGY_EXPONENTIAL)) {
            verifier = new ExponentialVerifier();
        } else {
            throw new RuntimeException("No such verifier strategy!");
        }
        if (fuzzMillis > 0L) {
            verifier.fuzzMillis = fuzzMillis;
        }
        verifier.verify(entries, spec);
    }

    public static boolean verify(List<MemcachedServer.CommandLogEntry> entries, RetrySpec spec, int opcode) {
        try {
            Verifier.verifyThrow(entries, spec, opcode);
            return true;
        }
        catch (VerificationException ex) {
            return false;
        }
    }

    public static class VerificationException
    extends Exception {
        public VerificationException(String message) {
            super(message);
        }
    }

    static class DurationExceededException
    extends VerificationException {
        public DurationExceededException(long expected, long actual) {
            super("Retries lasted for too long (`max-duration`). Expected: " + expected + ". Actual: " + actual);
        }
    }

    static class FirstRetryTooSoonException
    extends VerificationException {
        public FirstRetryTooSoonException() {
            super("Initial retry does not honor `after`");
        }
    }

    public static class ConstantVerifier
    extends Verifier {
        @Override
        protected void verifyImpl(List<MemcachedServer.CommandLogEntry> entries, RetrySpec spec) throws VerificationException {
            for (int i = 1; i < entries.size(); ++i) {
                long duration = entries.get(i).getMsTimestamp() - entries.get(i - 1).getMsTimestamp();
                if (Math.abs(duration - (long)spec.getInterval()) <= this.fuzzMillis) continue;
                throw new VerificationException("Too much spacing between intervals: " + duration + ". Expected: " + spec.getInterval());
            }
            long lastRetryExpected = entries.get(0).getMsTimestamp() + (long)(spec.getMaxDuration() - (spec.getInterval() + spec.getAfter()));
            long lastIntervalMaxDiff = this.fuzzMillis;
            long lastTimestamp = entries.get(entries.size() - 1).getMsTimestamp();
            if (Math.abs(lastTimestamp - lastRetryExpected) > lastIntervalMaxDiff) {
                throw new VerificationException(String.format("Not enough/too many retries. Last TS=%d. Last expected=%d. Diff=%d. MaxDiff=%d", lastTimestamp, lastRetryExpected, Math.abs(lastRetryExpected - lastTimestamp), lastIntervalMaxDiff));
            }
        }
    }

    public static class LinearVerifier
    extends Verifier {
        @Override
        protected void verifyImpl(List<MemcachedServer.CommandLogEntry> entries, RetrySpec spec) throws VerificationException {
            for (int i = 1; i < entries.size(); ++i) {
                long duration = entries.get(i).getMsTimestamp() - entries.get(i - 1).getMsTimestamp();
                long expectedDuration = spec.getInterval() * i;
                expectedDuration = Math.min((long)spec.getCeil(), expectedDuration);
                if (Math.abs(duration - expectedDuration) <= this.fuzzMillis) continue;
                throw new VerificationException("Linear backoff failed!.  duration: " + duration + ", expected: " + expectedDuration);
            }
        }
    }

    public static class ExponentialVerifier
    extends Verifier {
        @Override
        protected void verifyImpl(List<MemcachedServer.CommandLogEntry> entries, RetrySpec spec) throws VerificationException {
            for (int i = 1; i < entries.size(); ++i) {
                long duration = entries.get(i).getMsTimestamp() - entries.get(i - 1).getMsTimestamp();
                long expectedDuration = (long)Math.pow(spec.getInterval(), i);
                if (spec.getCeil() > 0) {
                    expectedDuration = Math.min((long)spec.getCeil(), expectedDuration);
                }
                if (Math.abs(duration - expectedDuration) <= this.fuzzMillis) continue;
                throw new VerificationException("Exponential backoff failed. Duration: " + duration + ", expected: " + expectedDuration);
            }
        }
    }
}

