/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.errormap;

import com.couchbase.mock.deps.com.google.gson.Gson;
import com.couchbase.mock.memcached.errormap.ErrorMapEntry;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.couchbase.mock.util.ReaderUtils;
import java.io.IOException;
import java.util.Map;

public class ErrorMap {
    public static final ErrorMap DEFAULT_ERRMAP;
    private int version;
    private int revision;
    private Map<String, ErrorMapEntry> errors;

    public static ErrorMap parse(String json) {
        return new Gson().fromJson(json, ErrorMap.class);
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public ErrorMapEntry getErrorEntry(int code) {
        code &= code & 0xFFFF;
        return this.errors.get(Integer.toHexString(code));
    }

    public ErrorMapEntry getErrorEntry(ErrorCode code) {
        return this.getErrorEntry(code.value());
    }

    static {
        try {
            String tmp = ReaderUtils.fromResource("errmap/errmap_v1.json");
            DEFAULT_ERRMAP = ErrorMap.parse(tmp);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

