/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.client;

import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MultiMutationResult {
    private final ErrorCode status;
    private final int index;
    private final String value;

    MultiMutationResult(ErrorCode status, int index, String value) {
        this.status = status;
        this.index = index;
        this.value = value;
    }

    public ErrorCode getStatus() {
        return this.status;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public static List<MultiMutationResult> parse(ByteBuffer bb) {
        bb.rewind();
        ArrayList<MultiMutationResult> res = new ArrayList<MultiMutationResult>();
        while (bb.hasRemaining()) {
            byte index = bb.get();
            ErrorCode ec = ErrorCode.valueOf(bb.getShort());
            String value = null;
            if (ec.value() == 0) {
                int valueLen = bb.getInt();
                byte[] valueBuf = new byte[valueLen];
                bb.get(valueBuf);
                value = new String(valueBuf);
            }
            res.add(new MultiMutationResult(ec, index, value));
        }
        return res;
    }
}

