/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.client;

import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.client.ClientResponse;
import com.couchbase.mock.memcached.client.CommandBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class MemcachedClient {
    final Socket socket;
    final InputStream input;
    final OutputStream output;

    public MemcachedClient(Socket socket) throws IOException {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
    }

    public ClientResponse readResponse() throws IOException {
        return ClientResponse.read(this.input);
    }

    public ClientResponse sendRequest(byte[] req) throws IOException {
        if (req.length < 24) {
            throw new IllegalArgumentException("Header too small..");
        }
        this.output.write(req);
        this.output.flush();
        return this.readResponse();
    }

    public ClientResponse sendRequest(CommandBuilder builder) throws IOException {
        return this.sendRequest(builder.build());
    }

    public void close() throws IOException {
        this.socket.close();
        this.input.close();
        this.output.close();
    }

    public MemcachedConnection getConnection(MemcachedServer server) throws IOException {
        return server.findConnection(this.socket.getLocalSocketAddress());
    }
}

