/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.ObsKeyState;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ObserveCode;
import java.security.AccessControlException;
import java.util.ArrayList;

public class ObserveCommandExecutor
implements CommandExecutor {
    @Override
    public BinaryResponse execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        BinaryObserveCommand command = (BinaryObserveCommand)cmd;
        Storage storage = server.getStorage();
        ArrayList<ObsKeyState> states = new ArrayList<ObsKeyState>();
        for (KeySpec spec : command.getKeySpecs()) {
            ObsKeyState kState;
            ObserveCode code;
            VBucketInfo vbInfo = storage.getVBucketInfo(spec.vbId);
            if (!vbInfo.hasAccess(server)) {
                throw new AccessControlException("not my vbucket");
            }
            Item cached = storage.getCached(spec);
            Item persisted = storage.getPersisted(spec);
            if (cached == null) {
                code = persisted == null ? ObserveCode.NOT_FOUND : ObserveCode.LOGICALLY_DELETED;
                kState = new ObsKeyState(spec, code, 0L);
            } else {
                code = persisted == null ? ObserveCode.NOT_PERSISTED : (persisted.getCas() != cached.getCas() ? ObserveCode.NOT_PERSISTED : ObserveCode.PERSISTED);
                kState = new ObsKeyState(cached, code);
            }
            states.add(kState);
        }
        return new BinaryObserveResponse(cmd, states);
    }
}

