/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.deps.org.apache.http.impl.entity;

import com.couchbase.mock.deps.org.apache.http.HttpException;
import com.couchbase.mock.deps.org.apache.http.HttpMessage;
import com.couchbase.mock.deps.org.apache.http.ProtocolException;
import com.couchbase.mock.deps.org.apache.http.annotation.Contract;
import com.couchbase.mock.deps.org.apache.http.annotation.ThreadingBehavior;
import com.couchbase.mock.deps.org.apache.http.entity.ContentLengthStrategy;
import com.couchbase.mock.deps.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

