/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.Serializable;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class AnalyticsMetrics
implements Serializable {
    private static final long serialVersionUID = -1955101433651194843L;
    public static final AnalyticsMetrics EMPTY_METRICS = new AnalyticsMetrics();
    public static final String NO_TIME = "0s";
    private final JsonObject rawMetrics;
    private final int resultCount;
    private final int errorCount;
    private final int warningCount;
    private final int mutationCount;
    private final int sortCount;
    private final long resultSize;
    private final String elapsedTime;
    private final String executionTime;

    private AnalyticsMetrics() {
        this(JsonObject.empty());
    }

    public AnalyticsMetrics(JsonObject rawMetrics) {
        this.rawMetrics = rawMetrics;
        this.elapsedTime = rawMetrics.getString("elapsedTime") == null ? NO_TIME : rawMetrics.getString("elapsedTime");
        this.executionTime = rawMetrics.getString("executionTime") == null ? NO_TIME : rawMetrics.getString("executionTime");
        this.resultCount = this.parseBestEffortToInt(rawMetrics, "resultCount");
        this.errorCount = this.parseBestEffortToInt(rawMetrics, "errorCount");
        this.warningCount = this.parseBestEffortToInt(rawMetrics, "warningCount");
        this.mutationCount = this.parseBestEffortToInt(rawMetrics, "mutationCount");
        this.sortCount = this.parseBestEffortToInt(rawMetrics, "sortCount");
        this.resultSize = this.parseBestEffortToLong(rawMetrics, "resultSize");
    }

    private int parseBestEffortToInt(JsonObject input, String fieldname) {
        Object value = input.get(fieldname);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    private long parseBestEffortToLong(JsonObject input, String fieldname) {
        Object value = input.get(fieldname);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    public String elapsedTime() {
        return this.elapsedTime;
    }

    public String executionTime() {
        return this.executionTime;
    }

    public int sortCount() {
        return this.sortCount;
    }

    public int resultCount() {
        return this.resultCount;
    }

    public long resultSize() {
        return this.resultSize;
    }

    public int mutationCount() {
        return this.mutationCount;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public JsonObject asJsonObject() {
        return this.rawMetrics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AnalyticsMetrics{");
        sb.append("resultCount=").append(this.resultCount);
        sb.append(", errorCount=").append(this.errorCount);
        sb.append(", warningCount=").append(this.warningCount);
        sb.append(", mutationCount=").append(this.mutationCount);
        sb.append(", sortCount=").append(this.sortCount);
        sb.append(", resultSize=").append(this.resultSize);
        sb.append(", elapsedTime='").append(this.elapsedTime).append('\'');
        sb.append(", executionTime='").append(this.executionTime).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

