/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractCompoundQuery;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DisjunctionQuery
extends AbstractCompoundQuery {
    private int min = -1;

    public DisjunctionQuery(AbstractFtsQuery ... queries) {
        super(queries);
    }

    @Override
    public DisjunctionQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    public DisjunctionQuery min(int min) {
        this.min = min;
        return this;
    }

    public DisjunctionQuery or(AbstractFtsQuery ... queries) {
        super.addAll(queries);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.childQueries.isEmpty()) {
            throw new IllegalArgumentException("Compound query has no child query");
        }
        if (this.childQueries.size() < this.min) {
            throw new IllegalArgumentException("Disjunction query as fewer children than the configured minimum " + this.min);
        }
        if (this.min > 0) {
            input.put("min", this.min);
        }
        JsonArray disjuncts = JsonArray.create();
        for (AbstractFtsQuery childQuery : this.childQueries) {
            JsonObject childJson = JsonObject.create();
            childQuery.injectParamsAndBoost(childJson);
            disjuncts.add(childJson);
        }
        input.put("disjuncts", disjuncts);
    }
}

